package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 供应商状态
 * @author Gary
 *
 */
public enum SupplierStatusEnum {
	
	REJECT(-1, "驳回"),
	UNSUBIMITTED(0, "草稿"),
	LEGAL_REVIEW(1, "品类经理审核"),
	CATEGORY_MANAGER_REVIEW(2, "品类经理审核"),
	COMPLETED_REVIEW(3, "审核完成");
	
	public final Integer status;
	public final String desc;

	public static final List<SupplierStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private SupplierStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {
        for (SupplierStatusEnum c : SupplierStatusEnum .values()) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}
	
	
}
