package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.StringUtils;

import com.thebeastshop.pegasus.util.importExcel.ExcelColumn;
import com.thebeastshop.pegasus.util.importExcel.ExcelTemplate;

/**
 * @author gongjun
 * @since 2016-10-28
 */
@ExcelTemplate
public class OpProductExcelVO implements Serializable {

    /**
     * ID
     */
    private Long id;

    @ExcelColumn(name="一级类目")
    @NotNull
    private String category1Name;

    private Long category1Id;

    @ExcelColumn(name="二级类目")
    @NotNull
    private String category2Name;

    private Long category2Id;

    private Date firstOnSaleTime;

    @ExcelColumn(name="SKU")
    @NotNull
    private String skuCodeList;

    private String brandName;

    /**
     * 产品编码
     */
    @ExcelColumn(name="PROD_CODE")
    @NotNull
    private String code;
    /**
     * 列表价
     */
    private BigDecimal listPrice;
    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;
    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;
    /**
     * 备货天数，默认0
     */
    private Integer prepareDays;
    /**
     * 可选择配送日期天数，0:尽快（不可选），n:n天内（默认n=7）
     */
    private Integer selectDeliveryDays;
    /**
     * 图片（列表）
     */
    private String picList;
    /**
     * 图片（详情）
     */
    private String picDetail;
    /**
     * Database Column Remarks:
     *   多张详情图片
     */
    private String picDetailMul;

    /**
     * 图片（缩略）
     */
    private String picThumb;

    /**
     * 产品名
     */
    @ExcelColumn(name="PROD_NAME")
    private String name;
    /**
     * 产品中文名
     */
    private String nameCn;
    /**
     * SKU分类描述
     */
    private String skuCategoryDesc;
    /**
     * 快递类型，1店送2联邦3顺丰
     */
    private Integer expressType;

    /**
     *
     */
    private List<String> skuCodes;
    private List<OpSpvVO> prodSkuVOs;

    @ExcelColumn(name="一级显示顺序")
    private Integer sort1;

    @ExcelColumn(name="二级显示顺序")
    private Integer sort2;

    //    @ExcelColumn(name="排序")
//    @NotNull
//    @Min(value=0)
    private Integer seq;


    public String getCategory1Name() {
        return category1Name;
    }

    public void setCategory1Name(String category1Name) {
        this.category1Name = category1Name;
    }

    public Long getCategory1Id() {
        return category1Id;
    }

    public void setCategory1Id(Long category1Id) {
        this.category1Id = category1Id;
    }

    public String getCategory2Name() {
        return category2Name;
    }

    public void setCategory2Name(String category2Name) {
        this.category2Name = category2Name;
    }

    public Long getCategory2Id() {
        return category2Id;
    }

    public void setCategory2Id(Long category2Id) {
        this.category2Id = category2Id;
    }

    public Date getFirstOnSaleTime() {
        return firstOnSaleTime;
    }

    public void setFirstOnSaleTime(Date firstOnSaleTime) {
        this.firstOnSaleTime = firstOnSaleTime;
    }

    public String getSkuCodeList() {
        return skuCodeList;
    }

    public void setSkuCodeList(String skuCodeList) {
        this.skuCodeList = skuCodeList;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public Integer getSort1() {
        return sort1;
    }

    public void setSort1(Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
        return sort2;
    }

    public void setSort2(Integer sort2) {
        this.sort2 = sort2;
    }

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    private List<OpProdCanDeliveryVO> prodCanDeliveryVOs;

    public List<OpProdCanDeliveryVO> getProdCanDeliveryVOs() {
        return prodCanDeliveryVOs;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public void setProdCanDeliveryVOs(List<OpProdCanDeliveryVO> prodCanDeliveryVOs) {
        this.prodCanDeliveryVOs = prodCanDeliveryVOs;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return picList;
    }

    public void setPicList(String picList) {
        this.picList = picList;
    }

    public String getPicDetailMul() {
        return picDetailMul;
    }

    public void setPicDetailMul(String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }

    public String getPicDetail() {
        return picDetail;
    }

    public void setPicDetail(String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return picThumb;
    }

    public void setPicThumb(String picThumb) {
        this.picThumb = picThumb;
    }

    public List<OpSpvVO> getProdSkuVOs() {
        return prodSkuVOs;
    }

    public void setProdSkuVOs(List<OpSpvVO> prodSkuVOs) {
        this.prodSkuVOs = prodSkuVOs;
    }

    public List<String> getPicDetails(){
        if (StringUtils.isBlank(picDetail)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(picDetail.split(","));
    }

}
