/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: BrandService.java, v 0.1 2015-07-10 下午4:49
 */
public interface McPcsBrandService {


    /**
     * 创建品牌
     *
     * @param record
     * @return
     */
    Long create(PcsBrandVO record, boolean saveDraft);

    /**
     * 创建品牌
     *
     * @param vo
     * @return
     */
    Long createBrand(PcsBrandVO vo);

    /**
     * 更新品牌
     *
     * @param record
     * @return
     */
    boolean update(PcsBrandVO record, boolean saveDraft);

    /**
     * 更新品牌
     *
     * @param vo
     * @return
     */
    boolean updateBrand(PcsBrandVO vo);

    /**
     * 根据主键查找品牌
     *
     * @param id
     * @return
     */
    PcsBrandVO findById(long id);

    /**
     * 根据条件查找品牌
     *
     * @param cond
     * @return
     */
    List<PcsBrandVO> findByCond(PcsBrandCond cond);

    /**
     * 根据名称查找品牌
     *
     * @param name
     * @return
     */
    List<PcsBrandVO> findByName(String name);

    /**
     * 根据id集合查找品牌
     *
     * @param ids
     * @return
     */
    List<PcsBrandVO> findByIds(List<Long> ids);
    
    /**
     * 品牌审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type);
    
    /**
     * 记录品牌总数
     * @param cond
     * @return
     */
    long countByCond(PcsBrandCond cond);

    /**
     * 根据类目code查找品牌
     *
     * @param cond
     * @return
     */
    List<PcsBrandVO> findByCondCategory(PcsBrandCond cond);

    /**
     * 根据IDS查找品牌
     *
     * @param cond
     * @return
     */
    List<PcsBrandVO> findByCondIds(PcsBrandCond cond);

}
