package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;

import com.thebeastshop.pegasus.merchandise.cond.PcsQualificationCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsQualificationVO;

public interface McPcsQualificationService {


	/**
     * 创建SKU资质文件
     * @param vo
     * @return
     */
    Long create(PcsQualificationVO vo);
    
    /**
     * 批量新增SKU资质文件
     * @param list
     * @return
     */
    List<Long> createPcsQualifications(List<PcsQualificationVO> list);
    
    List<Long> createPcsQualifications(List<PcsQualificationVO> qualificationVOs, Long qualifyId);
    
    /**
     * 删除SKU资质文件
     * @param vo
     * @return
     */
    int deleteById(Long id);
    
    /**
     * 删除SKU资质文件
     * @param vo
     * @return
     */
    Long deleteByQualifyId(Long qualifyId);

    /**
     * 更新SKU资质文件
     * @param vo
     * @return
     */
    Boolean update(PcsQualificationVO vo);

    /**
     * 根据ID查找SKU资质文件
     * @param id
     * @return
     */
    PcsQualificationVO findById(Long id);

    /**
     * 根据qualifyId查找SKU资质文件
     * @param id
     * @return
     */
    List<PcsQualificationVO> findByQualifyId(Long qualifyId);
    
    /**
     * 根据相应条件查找SKU资质文件
     * @param cond
     * @return
     */
    List<PcsQualificationVO> findByCond(PcsQualificationCond cond);

    /**
     * 根据条件查找SKU资质文件
     * @param cond
     * @return
     */
    List<PcsQualificationVO> findByCriteria(PcsQualificationCond cond);

    /**
     * 根据id集合查找SKU资质文件
     * @param ids
     * @return
     */
    List<PcsQualificationVO> findByIds(List<Long> ids);

    long countByCond(PcsQualificationCond cond);
    
}
