package com.thebeastshop.pegasus.merchandise.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Sku审核状态
 * @author Gary
 *
 */
public enum PcsSkuSalesPriceChangeStatusEnum {

	CUSTOMS_REVIEW(5, "关务审批"),
	LEGAL_REVIEW(1, "待品类经理审批"),
	FINANCE_REVIEW(4, "待财务审批"),
	COMPLETED_REVIEW(2, "审核完成"),
	REJECT(3, "驳回");

	public static final List<PcsSkuSalesPriceChangeStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));
	
	private final Integer status;
	
	private final String desc;


	PcsSkuSalesPriceChangeStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	/**
	 * 审核中的状态
	 * @return
	 */
	public static List<Integer> progressingStatusList() {
    List<Integer> statusList = new ArrayList<>();
		statusList.add(CUSTOMS_REVIEW.status);
		statusList.add(LEGAL_REVIEW.status);
		statusList.add(FINANCE_REVIEW.status);
		return statusList;
	}

	public final Integer getStatus() {
		return status;
	}

	public final String getDesc() {
		return desc;
	}


	 // 普通方法
    public static String getDesc(int status) {
        for (PcsSkuSalesPriceChangeStatusEnum c : PcsSkuSalesPriceChangeStatusEnum .values()) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }
}
