/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.thebeastshop.pegasus.util.comm.NumberUtil;

/**
 * @author Roy.Chen
 * @version $Id: PubSkuVO.java, v 0.1 2015-08-06 10:26
 */
public class PsSkuVO implements Serializable {

    private Long skuId;
    private String skuCode;
    private String skuName;
    private String skuNameCN;

    /**
     * SKU类型（创建后不可修改），1原材料2半成品3成品
     */
    private Integer skuType;

    /**
     * 是否自产（创建后不可修改），0否1是
     */
    private Integer isMadeBySelf;
    /**
     * 是否进口（创建后不可修改），0否1是
     */
    private Integer isImported;

    private List<String> smallIconList;

    private List<String> largeIconList;

    private List<PsTagVO> tagList;

    private Date saleStartDate;

    /**
     * 定制SKU编码，null表示不是定制产品
     */
    private String skuCustomMadeCode;

    /**
     * 组合SKU配方，null表示不是配方产品
     */
    private String combinedSkuRecipeCode;

    private Integer isSkuCustomMade;
    private Integer isCombinedSkuRecipeCode;
    /**
     * 是否来单制作（高单价的组合配方SKU），0否1是
     */
    private Integer isJit;
    /**
     * EAN13
     */
    private String ean13;
    /**
     * 条形码
     */
    private String barcode;
    /**
     * 是否可采购，0否1是
     */
    private Integer canPurchase;
    /**
     * 是否可定制
     */
    private Integer canCustomize;
    /**
     * 定制类型
     */
    private String customizeType;
    /**
     * 定制费
     */
    private BigDecimal customizationPrice;
    /**
     * 定制信息列表
     */
    private List<PsSkuCustomizationVO> customizationList;

    private PsCustomizeVO customize;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 售价
     */
    private Double salesPrice;
    /**
     * 最小订货量
     */
//    private Integer moq;

    /**
     * 品类
     */
    private Long categoryId;
    private String categoryName;

//    private Map<String, PcsSkuCategoryVO> categoryMap;

    private List<PcsSkuCategoryVO> frontCategoryList;

    /**
     * 品牌
     */
    private Long brandId;
    private String brandName;
    private String brandNameCN;
    private Long brandCountryId;
    private String brandCountryName;

    /**
     * 产地
     */
    private String placeOfOrigin;

    /**
     * 供应商
     */
    private Long supplierId;
    private String supplierName;
    private String supplierNameCN;

    /**
     * sku分类名
     */
    private String skuCateName;
    /**
     * 是否可以备注
     */
    private Integer canRemark;

    /**
     * 积分抵扣规则，0不可抵扣1部分抵扣2全部抵扣
     */
    private Integer pointDeductRule;
    /**
     * 积分抵扣使用积分
     */
    private BigDecimal pointDeductPoint;
    /**
     * 积分抵扣后金额
     */
    private BigDecimal pointDuductPrice;

    /**ChannelCODE channelCanSaleList = channelOnShelfList U channelOffShelfList
     * channelOnShelfList  上架列表
     * channelOffShelfList  下架列表
     */
//    private List<String> channelCanSaleList = new ArrayList<String>();
//    private List<String> channelOnShelfList = new ArrayList<String>();
//    private List<String> channelOffShelfList = new ArrayList<String>();

    private String updateTime;

    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag;

    /**
     *  净重
     */
    private String weight;
    /**
     *  税号
     */
    private String taxNo;

    /**
     * 折扣价
     */
    private BigDecimal discountPrice;

    /**
     * 优惠活动
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();

    private Integer canCustomizeSalesPrice;

    /**
     * 是否需要配送
     */
    private Integer whetherLogistics;

    /**
     * 是否需要配送
     */
    private Integer whetherVirtual;


    /**
     * 通关方式（0：未知，1：BC，2：个人）
     */
    private Short clearanceWay=0;

    private Integer whetherConsignment;

    private BigDecimal advancePrice;

    private Integer isMonthSend;
    
    private Integer monthSendDeliveryRule;
    
    private Integer deliveryTimes;

    private Date saleEndDate;

    private Integer skuStatus;

    private Integer deliveryPeriod;

    private PsStockVO psStockVO;

    private PcsCustomizeElementCacheVO pcsCustomizeElementCacheVO;

    private PsPresaleSaleStockVO psPresaleSaleStockVO;
    
    public Integer getIsMonthSend() {
		return isMonthSend;
	}

	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}

	public Integer getMonthSendDeliveryRule() {
		return monthSendDeliveryRule;
	}

	public void setMonthSendDeliveryRule(Integer monthSendDeliveryRule) {
		this.monthSendDeliveryRule = monthSendDeliveryRule;
	}

	public Integer getDeliveryTimes() {
		return deliveryTimes;
	}

	public void setDeliveryTimes(Integer deliveryTimes) {
		this.deliveryTimes = deliveryTimes;
	}

	public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public String getId() {
        return skuCode;
    }
    public BigDecimal getCostPrice() {
        return costPrice;
    }
    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }
    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getSkuNameCN() {
        return skuNameCN;
    }

    public void setSkuNameCN(String skuNameCN) {
        this.skuNameCN = skuNameCN;
    }

    public Integer getSkuType() {
        return skuType;
    }

    public void setSkuType(Integer skuType) {
        this.skuType = skuType;
    }

    public Integer getIsMadeBySelf() {
        return isMadeBySelf;
    }

    public void setIsMadeBySelf(Integer isMadeBySelf) {
        this.isMadeBySelf = isMadeBySelf;
    }

    public Integer getIsImported() {
        return isImported;
    }

    public void setIsImported(Integer isImported) {
        this.isImported = isImported;
    }


    public List<String> getLargeIconList() {
        return largeIconList;
    }

    public void setLargeIconList(List<String> largeIconList) {
        this.largeIconList = largeIconList;
    }

    public List<String> getSmallIconList() {
        return smallIconList;
    }

    public void setSmallIconList(List<String> smallIconList) {
        this.smallIconList = smallIconList;
    }

    public List<PsTagVO> getTagList() {
        return tagList;
    }

    public void setTagList(List<PsTagVO> tagList) {
        this.tagList = tagList;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public String getSkuCustomMadeCode() {
        return skuCustomMadeCode;
    }

    public void setSkuCustomMadeCode(String skuCustomMadeCode) {
        this.skuCustomMadeCode = skuCustomMadeCode;
    }

    public String getCombinedSkuRecipeCode() {
        return combinedSkuRecipeCode;
    }

    public void setCombinedSkuRecipeCode(String combinedSkuRecipeCode) {
        this.combinedSkuRecipeCode = combinedSkuRecipeCode;
    }

    public String getEan13() {
        return ean13;
    }

    public void setEan13(String ean13) {
        this.ean13 = ean13;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Integer getCanPurchase() {
        return canPurchase;
    }

    public void setCanPurchase(Integer canPurchase) {
        this.canPurchase = canPurchase;
    }

    public Integer getCanCustomize() {
        return canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }

    public String getCustomizeType() {
        return customizeType;
    }

    public void setCustomizeType(String customizeType) {
        this.customizeType = customizeType;
    }

    public BigDecimal getCustomizationPrice() {
        return customizationPrice;
    }

    public void setCustomizationPrice(BigDecimal customizationPrice) {
        this.customizationPrice = customizationPrice;
    }

    public List<PsSkuCustomizationVO> getCustomizationList() {
        return customizationList;
    }

    public void setCustomizationList(List<PsSkuCustomizationVO> customizationList) {
        this.customizationList = customizationList;
    }

    public PsCustomizeVO getCustomize() {
        return customize;
    }

    public void setCustomize(PsCustomizeVO customize) {
        this.customize = customize;
    }

    public Double getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(Double salesPrice) {
        this.salesPrice = salesPrice;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public List<PcsSkuCategoryVO> getFrontCategoryList() {
        return frontCategoryList;
    }

    public void setFrontCategoryList(List<PcsSkuCategoryVO> frontCategoryList) {
        this.frontCategoryList = frontCategoryList;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getBrandNameCN() {
        return brandNameCN;
    }

    public void setBrandNameCN(String brandNameCN) {
        this.brandNameCN = brandNameCN;
    }

    public Long getBrandCountryId() {
        return brandCountryId;
    }

    public void setBrandCountryId(Long brandCountryId) {
        this.brandCountryId = brandCountryId;
    }

    public String getBrandCountryName() {
        return brandCountryName;
    }

    public void setBrandCountryName(String brandCountryName) {
        this.brandCountryName = brandCountryName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSupplierNameCN() {
        return supplierNameCN;
    }

    public void setSupplierNameCN(String supplierNameCN) {
        this.supplierNameCN = supplierNameCN;
    }

//    public List<String> getChannelCanSaleList() {
//        return channelCanSaleList;
//    }
//
//    public void setChannelCanSaleList(List<String> channelCanSaleList) {
//        this.channelCanSaleList = channelCanSaleList;
//    }
//
//    public List<String> getChannelOnShelfList() {
//        return channelOnShelfList;
//    }
//
//    public void setChannelOnShelfList(List<String> channelOnShelfList) {
//        this.channelOnShelfList = channelOnShelfList;
//    }
//
//    public List<String> getChannelOffShelfList() {
//        return channelOffShelfList;
//    }
//
//    public void setChannelOffShelfList(List<String> channelOffShelfList) {
//        this.channelOffShelfList = channelOffShelfList;
//    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsSkuCustomMade() {
        return StringUtils.isBlank(skuCustomMadeCode)?0:1;
    }

    public Integer getIsCombinedSkuRecipeCode() {
        return StringUtils.isBlank(combinedSkuRecipeCode)?0:1;
    }
    public Integer getPointDeductRule() {
        return (Integer) NumberUtil.avoidNull(pointDeductRule, 0);
    }

    public void setPointDeductRule(Integer pointDeductRule) {
        this.pointDeductRule = pointDeductRule;
    }

    public BigDecimal getPointDeductPoint() {
        return pointDeductPoint == null?BigDecimal.ZERO:pointDeductPoint;
    }

    public void setPointDeductPoint(BigDecimal pointDeductPoint) {
        this.pointDeductPoint = pointDeductPoint;
    }

    public BigDecimal getPointDuductPrice() {
        return pointDuductPrice == null?BigDecimal.ZERO:pointDuductPrice;
    }

    public void setPointDuductPrice(BigDecimal pointDuductPrice) {
        this.pointDuductPrice = pointDuductPrice;
    }

    public String getSkuCateName() {
        return skuCateName;
    }

    public void setSkuCateName(String skuCateName) {
        this.skuCateName = skuCateName;
    }

    public Integer getCanRemark() {
        return canRemark;
    }

    public void setCanRemark(Integer canRemark) {
        this.canRemark = canRemark;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }


    public Short getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Short clearanceWay) {
        this.clearanceWay = clearanceWay;
    }

    public Integer getWhetherConsignment() {
        return whetherConsignment;
    }

    public void setWhetherConsignment(Integer whetherConsignment) {
        this.whetherConsignment = whetherConsignment;
    }

    public BigDecimal getAdvancePrice() {
        return advancePrice;
    }

    public void setAdvancePrice(BigDecimal advancePrice) {
        this.advancePrice = advancePrice;
    }

    public Integer getCanCustomizeSalesPrice() {
        return canCustomizeSalesPrice;
    }

    public void setCanCustomizeSalesPrice(Integer canCustomizeSalesPrice) {
        this.canCustomizeSalesPrice = canCustomizeSalesPrice;
    }

    public Date getSaleEndDate() {
        return saleEndDate;
    }

    public void setSaleEndDate(Date saleEndDate) {
        this.saleEndDate = saleEndDate;
    }

    public Integer getSkuStatus() {
        return skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public Integer getDeliveryPeriod() {
        return deliveryPeriod;
    }

    public void setDeliveryPeriod(Integer deliveryPeriod) {
        this.deliveryPeriod = deliveryPeriod;
    }

    public PsStockVO getPsStockVO() {
        return psStockVO;
    }

    public void setPsStockVO(PsStockVO psStockVO) {
        this.psStockVO = psStockVO;
    }

    public PsPresaleSaleStockVO getPsPresaleSaleStockVO() {
        return psPresaleSaleStockVO;
    }

    public void setPsPresaleSaleStockVO(PsPresaleSaleStockVO psPresaleSaleStockVO) {
        this.psPresaleSaleStockVO = psPresaleSaleStockVO;
    }

    public PcsCustomizeElementCacheVO getPcsCustomizeElementCacheVO() {
        return pcsCustomizeElementCacheVO;
    }

    public void setPcsCustomizeElementCacheVO(PcsCustomizeElementCacheVO pcsCustomizeElementCacheVO) {
        this.pcsCustomizeElementCacheVO = pcsCustomizeElementCacheVO;
    }

    public Integer getWhetherLogistics() {
        return whetherLogistics;
    }

    public void setWhetherLogistics(Integer whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    public Integer getWhetherVirtual() {
        return whetherVirtual;
    }

    public void setWhetherVirtual(Integer whetherVirtual) {
        this.whetherVirtual = whetherVirtual;
    }

    @Override
    public String toString() {
        return "PsSkuVO{" +
                "skuId=" + skuId +
                ", skuCode='" + skuCode + '\'' +
                ", skuName='" + skuName + '\'' +
                ", skuNameCN='" + skuNameCN + '\'' +
                ", skuType=" + skuType +
                ", isMadeBySelf=" + isMadeBySelf +
                ", isImported=" + isImported +
                ", smallIconList=" + smallIconList +
                ", largeIconList=" + largeIconList +
                ", tagList=" + tagList +
                ", saleStartDate=" + saleStartDate +
                ", skuCustomMadeCode='" + skuCustomMadeCode + '\'' +
                ", combinedSkuRecipeCode='" + combinedSkuRecipeCode + '\'' +
                ", isSkuCustomMade=" + isSkuCustomMade +
                ", isCombinedSkuRecipeCode=" + isCombinedSkuRecipeCode +
                ", isJit=" + isJit +
                ", ean13='" + ean13 + '\'' +
                ", barcode='" + barcode + '\'' +
                ", canPurchase=" + canPurchase +
                ", canCustomize=" + canCustomize +
                ", customizationPrice=" + customizationPrice +
                ", customizationList=" + customizationList +
                ", customize=" + customize +
                ", costPrice=" + costPrice +
                ", salesPrice=" + salesPrice +
                ", categoryId=" + categoryId +
                ", categoryName='" + categoryName + '\'' +
                ", frontCategoryList=" + frontCategoryList +
                ", brandId=" + brandId +
                ", brandName='" + brandName + '\'' +
                ", brandNameCN='" + brandNameCN + '\'' +
                ", brandCountryId=" + brandCountryId +
                ", brandCountryName='" + brandCountryName + '\'' +
                ", placeOfOrigin='" + placeOfOrigin + '\'' +
                ", supplierId=" + supplierId +
                ", supplierName='" + supplierName + '\'' +
                ", supplierNameCN='" + supplierNameCN + '\'' +
                ", skuCateName='" + skuCateName + '\'' +
                ", canRemark=" + canRemark +
                ", pointDeductRule=" + pointDeductRule +
                ", pointDeductPoint=" + pointDeductPoint +
                ", pointDuductPrice=" + pointDuductPrice +
                ", updateTime='" + updateTime + '\'' +
                ", crossBorderFlag=" + crossBorderFlag +
                ", weight='" + weight + '\'' +
                ", taxNo='" + taxNo + '\'' +
                ", discountPrice=" + discountPrice +
                ", campaignList=" + campaignList +
                ", clearanceWay=" + clearanceWay +
                ", whetherConsignment=" + whetherConsignment +
                ", advancePrice=" + advancePrice +
                '}';
    }
}
