package com.thebeastshop.pegasus.merchandise.validation;


import com.thebeastshop.common.exception.BaseErrorCode;
import com.thebeastshop.common.prop.PropConstants;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.pegasus.merchandise.exception.DynmDetailsException;
import com.thebeastshop.pegasus.merchandise.exception.DynmDetailsExceptionCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;

import java.util.Collection;
import java.util.Map;

/**
 * 验证工具类
 * @author meng.li[vans.li@thebeastshop.com]
 * @since 2018-05-10 18:59
 */
public class DynmDetailsValidation {

    private final static Logger log = org.slf4j.LoggerFactory.getLogger(DynmDetailsValidation.class);

    private DynmDetailsValidation() {
    }

    public static void assertNotNull(Object object, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (object == null) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotNull(Object object,  String msg) {
        if (object == null) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (CollectionUtils.isEmpty(collection)) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(Collection collection, String msg) {
        if (CollectionUtils.isEmpty(collection)) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(CharSequence str, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (EmptyUtil.isEmpty(str)) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(String str, String msg) {
        if (EmptyUtil.isEmpty(str)) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertNotEmpty(Map map, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (MapUtils.isEmpty(map)) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertNotEmpty(Map map, String msg) {
        if (MapUtils.isEmpty(map)) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertTrue(boolean condition, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (!condition) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void assertTrue(boolean condition, String msg) {
        if (!condition) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void assertTrue(boolean condition, DynmDetailsExceptionCode exceptionCode) {
        assertTrue(condition, exceptionCode, null);
    }


    public static void rejectIf(Boolean condition, DynmDetailsExceptionCode exceptionCode, String msg) {
        if (condition) {
            throwValidationException(exceptionCode, msg);
        }
    }

    public static void rejectIf(Boolean condition, DynmDetailsExceptionCode exceptionCode) {
        rejectIf(condition, exceptionCode, null);
    }


    public static void rejectIf(Boolean condition, String msg) {
        if (condition) {
            throwValidationException(DynmDetailsExceptionCode.VALIDATION_FAIL, msg);
        }
    }

    public static void paramNotNull(Object obj, String msg) {
        if (obj == null) {
            throwParamException(DynmDetailsExceptionCode.NULL_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Collection collection, String msg) {
        if (EmptyUtil.isEmpty(collection)) {
            throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(CharSequence str, String msg) {
        if (EmptyUtil.isEmpty(str)) {
            throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramNotEmpty(Map map, String msg) {
        if (EmptyUtil.isEmpty(map)) {
            throwParamException(DynmDetailsExceptionCode.EMPTY_PARAM, msg);
        }
    }

    public static void paramMust(Boolean condition, String msg) {
        if (!condition) {
            throwParamException(DynmDetailsExceptionCode.ILLEGAL_PARAM, msg);
        }
    }

    private static StackTraceElement getStrackElement(int index) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[index];
        return stackTraceElement;
    }

    private static void throwValidationException(BaseErrorCode errorCode, String msg) {
        throwValidationException("数据校验错误", errorCode, msg, 5);
    }

    private static void throwParamException(BaseErrorCode errorCode, String msg) {
        throwValidationException("参数校验错误", errorCode, msg, 5);
    }

    private static void throwValidationException(String type, BaseErrorCode errorCode, String msg, int index) {
        StackTraceElement stackTraceElement = getStrackElement(index);
        String class_method = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
        String appId = PropConstants.getAppId();
        String text = "[" + appId + "] [" + type + ": " + errorCode.getErrorCode() + "] 调用方法[" + class_method + "]时" + errorCode.getMessage() + ": " + msg;
        log.error(text);
        throw new DynmDetailsException((DynmDetailsExceptionCode) errorCode, msg);
    }





}
