package com.thebeastshop.pegasus.merchandise.service;


import java.util.List;

import com.thebeastshop.pegasus.merchandise.cond.PcsSupplierCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSupplierVO;
import com.thebeastshop.pegasus.merchandise.vo.SupplierBrandRelation;

/**
 * @author Eric.Lou
 * @version $Id: McPcsSupplierService.java, v 0.1 2015-07-27 17:51
 */
public interface McPcsSupplierService {


    /**
     * 创建供应商
     *
     * @param record
     * @return
     */
    Long create(PcsSupplierVO vo, boolean saveDraft);

    /**
     * 创建供应商
     *
     * @param vo
     * @return
     */
    Long createSupplier(PcsSupplierVO vo);


    /**
     * 更新供应商
     *
     * @param record
     * @return
     */
    Boolean update(PcsSupplierVO vo, boolean saveDraft);


    /**
     * 更新供应商
     *
     * @param vo
     * @return
     */
    public Boolean updateSupplier(PcsSupplierVO vo);

    /**
     * 根据ID查找供应商
     *
     * @param id
     * @return
     */
    PcsSupplierVO findById(Long id);

    /**
     * 根据供应商名称和状态查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplierVO> findByCond(PcsSupplierCond cond);

    /**
     * 根据条件查找供应商
     *
     * @param cond
     * @return
     */
    List<PcsSupplierVO> findByCriteria(PcsSupplierCond cond);

    /**
     * 根据名称查找供应商
     *
     * @param name
     * @return
     */
    List<PcsSupplierVO> findByName(String name);

    /**
     * 根据id集合查找供应商
     *
     * @param ids
     * @return
     */
    List<PcsSupplierVO> findByIds(List<Long> ids);

    /**
     * 供应商审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean audiSupplier(Long userId, long id, Boolean isPass, Integer type);
    
    long countByCond(PcsSupplierCond cond);
    
    /**
     * 查询供应商和品牌关联关系
     *
     * @param cond
     * @return
     */
    List<SupplierBrandRelation> findSupplierBrandRelation();
    
    
    List<Integer> addPurchaseCategory(Integer supplierId, List<String> categoryList);
    
    List<Integer> addBusinessCategory(Integer supplierId, List<String> categoryList);
    
    /**
     * 保存基本信息
     * @param vo
     * @return
     */
    Boolean save(PcsSupplierVO vo);
    
    /**
     * 添加供应商工厂
     * @param supplierId
     * @param factoryList
     * @return
     */
    List<Integer> addFactorys(Integer supplierId, List<Long> factoryList);

    /**
     * @param ids
     * @return
     */
    List<PcsSupplierVO> getSupplierListByIds(List<Long> ids);

    List<PcsSupplierVO> listFactoryLikeName(String factoryName);
}
