/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.service;


import java.util.List;
import java.util.Map;
import java.util.Set;

import com.github.pagehelper.PageInfo;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuAuditRecordsVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuBarcodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuConfigItemsDTO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomsInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDTO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuPlanningVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;

/**
 * @author Eric.Lou
 * @version $Id: McPcsSkuService.java, v 0.1 2015-08-03 下午06:13
 */
public interface McPcsSkuService {


    /**
     * 创建sku
     *
     * @param record
     * @return
     */
    Long create(PcsSkuVO vo);

    /**
     * 批量创建SKU
     * @param list
     * @return
     */
    List<Long> createSkus(List<PcsSkuVO> list);
    

    /**
     * 更新sku
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuVO vo);

    /**
     * 根据主键查找sku
     *
     * @param id
     * @return
     */
    PcsSkuVO findById(long id);

    /**
     * 根据CODE查找sku
     *
     * @param code
     * @return
     */
    PcsSkuVO findByCode(String code);

    PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories);

    PcsSkuVO findByCode(String code, boolean widthFrontCategories, boolean withBackCategories, boolean withBuyerName);
    
    List<Map<String,Object>> findSkuCanSaleAndCanSeeByChannelCode(String channelCode);
    
    Map<String,Object> findSkuCanSaleAndCanSeeInfo(String channelCode, String skuCode);

    /**
     * 根据参数查找sku
     * @param nameCode
     * @return
     */
    List<PcsSkuVO> findByNameOrCode(String nameCode);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCond(PcsSkuCond cond);

    /**
     * 查询审核中的sku
     * @param cond
     * @return
     */
    List<PcsSkuVO> findAuditSkuByCond(PcsSkuCond cond);

    /**
     * 关务审批查询
     * @param cond
     * @return
     */
    List<PcsSkuVO> findCustomsAuditSkuByCond(PcsSkuCond cond);

    /**
     * 自进口SKU查询
     * @param cond
     * @return
     */
    PageInfo<PcsSkuVO> findOwnImportSkuByCond(PcsSkuCond cond);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuRangeStructureByCond(PcsSkuCond cond);


    /**
     * 根据条件查找sku
     * 导出使用
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findByCondForExport(PcsSkuCond cond);

    /**
     * 根据条件查找sku
     *
     * @param cond
     * @return
     */
    List<PcsSkuVO> findSkuTagByCond(PcsSkuCond cond);
    /**
     * 是否可以更新售价
     *
     * @param code
     * @return
     */
    Boolean canUpdateSkuSalesPrice(String code);

    /**
     * 售价变更审批
     *
     * @param code
     * @param isPass
     * @return
     */
    Boolean auditSkuSalesPriceChange(String code, Boolean isPass, Integer type);

    /**
     * 根据skucode查找 审批中的售价变更记录
     *
     * @param code
     * @return
     */
    /*PcsSkuSalesPriceChangeVO findSkuSalesPriceChangeByCodeAndProcessing(String code);*/

    /**
     * 根据CODE集合查找sku
     *
     * @param codes
     * @return
     */
    List<PcsSkuVO> findSkuByCodes(List<String> codes);

    List<PcsSkuVO> findSkuByCodes(List<String> codes, boolean withCategories);

    List<PcsSkuVO> findSkuByCodesWithCategories(List<String> codes, boolean withCategories);

    /**
     * 转换sku
     *
     * @param sku
     * @param skuCustomMadeId
     * @return
     */
    Boolean convertSku(PcsSkuVO sku, long skuCustomMadeId);

    /**
     * 转移sku
     * */
    boolean transferSku(List<String> skuCodes,Long buyerId);



    /**
     * 所有SKU信息
     *
     * @return
     */
    List<PcsSkuInfoVO> allSkuInfo();

    /**
     * 所有SKU信息
     *
     * @return
     */
    PcsSkuInfoVO findStockByCode(String skuCode);

    List<PcsSkuVO> findChannelSkuForNoDistribute(PcsSkuCond cond);

    void setSkuChannel(List<String> skuCodeList, List<String> channelCodeList, Long operatorId);
    
    List<PcsSkuVO> findSkuByIds(List<Long> ids);
    
    Boolean canUpdateCostPrice(String code);
    
    Boolean canUpdateSupplier(String code);
    
    /**
     * sku总数计算
     * @param cond
     * @return
     */
    long countSkuByCond(PcsSkuCond cond);

    String getCrossBorderFlagByCodes(List<String> codes);

    Integer updateSkuCategoryNameByCode(String skuCategoryName, String skuCode);

    List<Integer> getSalesPriceByCodes(List<String> codes);

    public List<Map> getSalesPriceByProdId(Long prodId);

    List<PcsSkuVO> findSkuAuditByIds(List<Long> ids);

    List<PcsSkuBarcodeVO> selectByBarCode(String barCode);

    List<PcsSkuVO> findSkuBySupplierId(Long supplierId);

    /**
     * 更新成品成本
     * @param vo
     * @return
     */
    boolean updatePrdcRecipeSkuCost(PcsSkuVO vo);

    /**
     * 只更新sku数据
     * @param vo
     * @return
     */
    int updateSku(PcsSkuVO vo);

    boolean costPriceNeedApproval(PcsSkuVO vo);

    public Integer getMonthlyByCodes(List<String> skuCodes);

	List<PcsSkuVO> findSkuQualifyByCond(PcsSkuCond cond);

	List<PcsSkuVO> findSkuQualifyByInCond(PcsSkuCond cond);

    List<PcsSkuVO> findSharedImportDoc();

    List<PcsSkuVO> findSharedAptitude();

    void autoUpdateServiceLevel();

    Map<String, PcsSkuDTO> getSkuNameByCodes(Set<String> skuCodes);

    PcsSkuConfigItemsDTO findSkuConfigItemsBySkuCode(String skuCode);

    List<PcsSkuConfigItemsDTO> findSkuConfigItemsBySkuCode(List<String> skuCodes);

    PcsSkuPlanningVO findSkuPlanningInfoBySkuCode(String skuCode);

    List<PcsSkuPlanningVO> findSkuPlanningInfoBySkuCode(List<String> skuCodeList);

    List<PcsSkuAuditRecordsVO> findAuditRecordsByCodeAndStatus(String skuCode, Integer auditStatus);

    Map<String, PcsSkuAuditRecordsVO> mapAuditRecordsByCodeAndStatus(List<String> skuCodeList, Integer auditStatus);

    PcsSkuAuditRecordsVO findAuditRecordsByCodeAndProcessing(String skuCode);

    /**
     * check是否需要关务审批
     * @param oldVO
     * @param newVO
     * @return
     */
    boolean needCustomsReview(PcsSkuVO oldVO, PcsSkuVO newVO);

    /**
     * 关务审批SKU
     * @param pcsSkuVO
     * @param isPass
     * @param remark
     * @return
     */
    boolean customsAuditSku(PcsSkuVO pcsSkuVO, boolean isPass, String remark);

    List<PcsSkuVO> findSkuByTaxIdList(List<String> taxIdList);

    int updateSkus(List<PcsSkuVO> list);


    /**
     * 查询正在审核中的审核记录(SKU只能有一条审核中的记录)
     * @param skuCode
     * @return
     */
    PcsSkuAuditRecordsVO findProcessingAuditBySkuCode(String skuCode);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoBySkucodes(List<String> skuCodeList);

    PcsSkuCustomsInfoVO findCustomsInfoBySkucode(String skuCode);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoByRecordNos(List<String> recordNoList);

    Map<String, PcsSkuCustomsInfoVO> findCustomsInfoByItemNumbers(List<String> itemNumberList);

    int batchInsertOrUpdateRecordNo(List<PcsSkuCustomsInfoVO> customsInfoList);

    List<String> refreshSkuData();

    Map<String, PcsSkuBarcodeVO> findBarcodeBySkuCodes(List<String> skuCodes);

    /**
     * planning 修改sku信息
     * @param planningInfo
     * @return
     */
    int planningToEditSku(PcsSkuPlanningVO planningInfo);

    int planningToEditSku(List<PcsSkuPlanningVO> planningInfoList) ;

    List<PcsSkuDTO> listSkuByCategoryIds(List<Long> categoryIds);
}
