package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * sku状态枚举
 * @author Gary
 *
 */
public enum PcsSkuStatusEnum {
	
	REJECT(2, "驳回"),
	UNSUBIMITTED(0, "草稿"),
	CUSTOMS_REVIEW(5, "关务审批"),
	LEGAL_REVIEW(1, "品类经理审核"),
	FINANCE_REVIEW(3, "财务审核"),
	COMPLETED_REVIEW(9, "审核完成");
	
	public final Integer status;
	public final String desc;

	public static final List<PcsSkuStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private PcsSkuStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (PcsSkuStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
