/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.util.comm.NumberUtil;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Roy.Chen
 * @version $Id: OpChannelCanSaleSkuVO.java, v 0.1 2015-08-03 17:16
 */
public class OpChnCanSaleProdVO implements Serializable {
    private Long id;
    /**
     * 渠道编码
     */
    private String channelCode;
    private String channelName;
    private Long productId;

    private String prodCode;
    private String prodName;
    private String prodNameCn;

    /**
     * 上下架状态 0-已下架 1-已上架 2-待审批 3-待上架
     */
    private Integer onShelf;

    private String onShelfStr;

    private Date createTime;
    /**
     * 可售sku
     */
    protected String canSaleSku;
    /**
     * 可见sku
     */
    protected String canSeeSku;



    private Integer createUserId;
    private String createUserName;
    private Date updateDateTime;


    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getCanSeeSku() {
        return canSeeSku == null?"":canSeeSku;
    }

    public void setCanSeeSku(String canSeeSku) {
        this.canSeeSku = canSeeSku;
    }

    public String getProdName() {
        return prodName;
    }

    public void setProdName(String prodName) {
        this.prodName = prodName;
    }

    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Integer getOnShelf() {
        return onShelf;
    }
    public void setOnShelf(Integer onShelf) {
        this.onShelfStr = NumberUtil.isNullOrZero(onShelf) ? "已下架" :  "已上架";
        this.onShelf = onShelf;
    }

    public void setOnShelfStr(String onShelfStr) {
        this.onShelfStr = onShelfStr;
    }
    public String getOnShelfStr() {
        return this.onShelfStr;
    }

    public String getCanSaleSku() {
        return canSaleSku == null?"":canSaleSku;
    }

    public void setCanSaleSku(String canSaleSku) {
        this.canSaleSku = canSaleSku;
    }

    public String getProdNameCn() {
        return prodNameCn;
    }

    public void setProdNameCn(String prodNameCn) {
        this.prodNameCn = prodNameCn;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }


    public Integer getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Date getUpdateDateTime() {
        return updateDateTime;
    }

    public void setUpdateDateTime(Date updateDateTime) {
        this.updateDateTime = updateDateTime;
    }

}
