package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 价格计算类型
 * 
 * @author Paul-xiong
 *
 */
public enum PriceCalTypeEnum{
	/**
	 * 会员折扣
	 */
	MEMBER_LEVEL(1, "会员折扣"),
	/**
	 * 活动
	 */
	CAMPAIGN(2, "活动"),
	/**
	 * 优惠券
	 */
	COUPON(3, "优惠券"),
	/**
	 * 生日折扣
	 */
	BIRTHDAY(4, "生日折扣"),;

	public final Integer id;
	public final String name;

	public static final List<PriceCalTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PriceCalTypeEnum(final Integer id, final String name) {
		this.id = id;
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

}
