package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.List;

/**
 * 安装服务枚举
 */
public enum  PcsSkuInstallServiceEnum {

  NOT_NEED_INSTALL(0, "无需安装"),
  SELF_INSTALL(1, "自行安装"),
  HELP_INSTALL(2, "需要安装");

   private Integer key;
   private String desc;

  PcsSkuInstallServiceEnum(Integer key, String desc) {
    this.key = key;
    this.desc = desc;
  }

  public final static List<PcsSkuInstallServiceEnum> getAll() {
   return Arrays.asList(PcsSkuInstallServiceEnum.values());
  }

  public static String  getDesc(Integer key) {
    for (PcsSkuInstallServiceEnum pcsSkuInstallServiceEnum : PcsSkuInstallServiceEnum.values()) {
      if (pcsSkuInstallServiceEnum.key.equals(key)) {
        return pcsSkuInstallServiceEnum.desc;
      }
    }
    return  "";
  }

  public static Integer  getKey(String desc) {
    for (PcsSkuInstallServiceEnum pcsSkuInstallServiceEnum : PcsSkuInstallServiceEnum.values()) {
      if (pcsSkuInstallServiceEnum.desc.equals(desc)) {
        return pcsSkuInstallServiceEnum.key;
      }
    }
    return  null;
  }

  public Integer getKey() {
    return key;
  }

  public String getDesc() {
    return desc;
  }
}
