package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;

/**
 * @author gongjun
 * @since 2016-10-19
 */
public class PcsSkuCombinationVO implements Serializable {

    private Long id;

    /**
     * SPV ID
     */
    private Long spvId;

    /**
     * 绑定数量
     */
    private Integer quantity;

    /**
     * 子SKU CODE
     */
    private String subSkuCode;

    private String skuNameCn;
    private String skuName;
    private BigDecimal skuConstPrice;
    private BigDecimal skuSalesPrice;

    /**
     * 子SKU
     */
    private PcsSkuVO subSkuVO;

    /**
     * 属性名
     */
    private String attrName;

    /**
     * 属性值文本
     */
    private String attrValue;

    /**
     * 属性JSON字符串
     */
    private String attrs;

    /**
     * 商品组名
     */
    private String groupName;

    /**
     * 价格变更老售价
     */
    private BigDecimal lastSalesPrice;
    /**
     * 价格变更售价
     */
    private BigDecimal salesPrice;
    /**
     * 价格变更状态
     */
    private Integer changeStatus;

    /**
     * sku组合对应属性值 {AttrId -> AttrValueId}
     */
    private LinkedHashMap<Long, Long> attrValueIds;

    /**
     * 属性id
     */
    private Long attributeId;

    /**
     * 属性对象
     */
    private OpAttributeVO opAttributeVO;

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 是否可用
     */
    private Boolean active;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public String getSubSkuCode() {
        return subSkuCode;
    }

    public void setSubSkuCode(String subSkuCode) {
        this.subSkuCode = subSkuCode;
    }

    public PcsSkuVO getSubSkuVO() {
        return subSkuVO;
    }

    public void setSubSkuVO(PcsSkuVO subSkuVO) {
        this.subSkuVO = subSkuVO;
    }

    public String getAttrName() {
        return attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getAttrValue() {
        return attrValue;
    }

    public void setAttrValue(String attrValue) {
        this.attrValue = attrValue;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }


    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public LinkedHashMap<Long, Long> getAttrValueIds() {
        return attrValueIds;
    }

    public void setAttrValueIds(LinkedHashMap<Long, Long> attrValueIds) {
        this.attrValueIds = attrValueIds;
    }

    public Long getAttributeId() {
        return attributeId;
    }

    public void setAttributeId(Long attributeId) {
        this.attributeId = attributeId;
    }

    public OpAttributeVO getOpAttributeVO() {
        return opAttributeVO;
    }

    public void setOpAttributeVO(OpAttributeVO opAttributeVO) {
        this.opAttributeVO = opAttributeVO;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSkuConstPrice() {
        return skuConstPrice;
    }

    public void setSkuConstPrice(BigDecimal skuConstPrice) {
        this.skuConstPrice = skuConstPrice;
    }

    public BigDecimal getSkuSalesPrice() {
        return skuSalesPrice;
    }

    public void setSkuSalesPrice(BigDecimal skuSalesPrice) {
        this.skuSalesPrice = skuSalesPrice;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public BigDecimal getLastSalesPrice() {
        return lastSalesPrice;
    }

    public void setLastSalesPrice(BigDecimal lastSalesPrice) {
        this.lastSalesPrice = lastSalesPrice;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
}
