package com.thebeastshop.pegasus.merchandise.cond;

import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-07-18
 */
public class PsMatchCampaignCond extends BaseQueryCond {

    protected Boolean matchGlobalCampaigns = true;

    protected Boolean matchCampaign = false;

    private List<Long> campaignIds;

    List<Integer> discountTypeIds;

    List<Integer> productScopeIds;

    List<Integer> states;

    private Integer memberLevel;

    private Integer accessWay;

    private BigDecimal discount;

    private BigDecimal bdDiscount;

    public static PsMatchCampaignCond buildCond(Integer accessWay, Integer memberLevel) {
        PsMatchCampaignCond cond = new PsMatchCampaignCond();
        cond.setMatchCampaign(true);
        cond.setAccessWay(accessWay);
        cond.setMemberLevel(memberLevel);
        return cond;
    }

    public Boolean getMatchGlobalCampaigns() {
        return matchGlobalCampaigns;
    }

    public List<Long> getCampaignIds() {
        return campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public List<Integer> getDiscountTypeIds() {
        return discountTypeIds;
    }

    public void setDiscountTypeIds(List<Integer> discountTypeIds) {
        this.discountTypeIds = discountTypeIds;
    }

    public List<Integer> getProductScopeIds() {
        return productScopeIds;
    }

    public void setProductScopeIds(List<Integer> productScopeIds) {
        this.productScopeIds = productScopeIds;
    }

    public List<Integer> getStates() {
        return states;
    }

    public void setStates(List<Integer> states) {
        this.states = states;
    }

    public void setMatchGlobalCampaigns(Boolean matchGlobalCampaigns) {
        this.matchGlobalCampaigns = matchGlobalCampaigns;
    }

    public Boolean getMatchCampaign() {
        return matchCampaign;
    }

    public void setMatchCampaign(Boolean matchCampaign) {
        this.matchCampaign = matchCampaign;
    }

    public Integer getMemberLevel() {
        return memberLevel;
    }

    public void setMemberLevel(Integer memberLevel) {
        this.memberLevel = memberLevel;
    }

    public Integer getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(Integer accessWay) {
        this.accessWay = accessWay;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getBdDiscount() {
        return bdDiscount;
    }

    public void setBdDiscount(BigDecimal bdDiscount) {
        this.bdDiscount = bdDiscount;
    }
}
