/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.sms;

import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsTemplateUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsTemplateUtil.class);
    private static Map<String, Template> __cachedTemplateMap = new ConcurrentHashMap<String, Template>();

    public static String fromTemplate(String templateName, Map<String, Object> params) {
        String result;
        Template tpl = __cachedTemplateMap.get(templateName);
        if (tpl == null) {
            throw new IntegrationException("can't find template for name : " + templateName);
        }
        StringWriter sw = new StringWriter();
        try {
            tpl.process(params, (Writer)sw);
            result = sw.toString();
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            throw new IntegrationException("SmsTemplateUtil.fromTemplate failed : " + templateName + " : " + params);
        }
        return result;
    }

    static {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/config/smsTemplate");
        Configuration cfg = new Configuration();
        Enumeration<String> codeTempNames = config.getKeys();
        while (codeTempNames.hasMoreElements()) {
            String codeTemplateName = codeTempNames.nextElement();
            try {
                Template tpl = new Template(codeTemplateName, new String(config.getString(codeTemplateName).getBytes("UTF-8"), "UTF-8"), cfg);
                __cachedTemplateMap.put(codeTemplateName, tpl);
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
    }
}

