/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.pay;

import com.thebeastshop.pegasus.integration.pay.AliPayUtil;
import com.thebeastshop.pegasus.integration.pay.WeiXinPayUtil;
import com.thebeastshop.pegasus.integration.pay.vo.AliPayVO;
import com.thebeastshop.pegasus.integration.pay.vo.PayStatusVO;
import com.thebeastshop.pegasus.integration.pay.vo.WeiXinVO;
import com.thebeastshop.pegasus.util.comm.DateTool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayStatusQueryUtil {
    private final Logger log = LoggerFactory.getLogger(PayStatusQueryUtil.class);
    private static final PayStatusQueryUtil instance = new PayStatusQueryUtil();

    public static PayStatusQueryUtil getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        PayStatusQueryUtil payStatusQueryUtil = PayStatusQueryUtil.getInstance();
        PayStatusVO payStatusVO = payStatusQueryUtil.findThirdPayStatusVO("SO0110060001953968", 3, false);
        System.out.println(payStatusVO.toString());
    }

    public PayStatusVO findThirdPayStatusVO(String orderCode, int channelType, Boolean isOverSea) {
        PayStatusVO payStatusVO = new PayStatusVO();
        Boolean res = false;
        if (StringUtils.isNotBlank((CharSequence)orderCode)) {
            if (isOverSea.booleanValue()) {
                AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 3);
                this.convertPayStatusVO(3, aliPayVO, null, payStatusVO);
            } else {
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode, channelType);
                this.convertPayStatusVO(1, null, weiXinVO, payStatusVO);
                if (channelType == 3) {
                    if (!payStatusVO.getIsSuccess().booleanValue()) {
                        AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 4);
                        this.convertPayStatusVO(4, aliPayVO, null, payStatusVO);
                    }
                } else if (!payStatusVO.getIsSuccess().booleanValue()) {
                    AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 2);
                    this.convertPayStatusVO(2, aliPayVO, null, payStatusVO);
                }
            }
        }
        return payStatusVO;
    }

    private void convertPayStatusVO(int type, AliPayVO aliPayVO, WeiXinVO weiXinVO, PayStatusVO payStatusVO) {
        if (type == 1) {
            Boolean f = this.ifWeiXinPayStatus(weiXinVO);
            payStatusVO.setIsSuccess(f);
            payStatusVO.setPayType(type);
            if (f.booleanValue()) {
                payStatusVO.setPayPrice(weiXinVO.getTotalFee() + "");
                payStatusVO.setTradeOrderCode(weiXinVO.getTransactionId());
                if (StringUtils.isNotBlank((CharSequence)weiXinVO.getTimeEnd())) {
                    payStatusVO.setPayTime(DateTool.string2Date((String)weiXinVO.getTimeEnd(), (String)"yyyyMMddHHmmss"));
                }
            }
        } else {
            Boolean f = this.ifPayStatus(aliPayVO);
            payStatusVO.setIsSuccess(f);
            payStatusVO.setPayType(type);
            if (f.booleanValue()) {
                Double to = Double.valueOf(aliPayVO.getResponseVO().get(0).getTrade().getTotalFee()) * 100.0;
                payStatusVO.setPayPrice(to.intValue() + "");
                payStatusVO.setTradeOrderCode(aliPayVO.getResponseVO().get(0).getTrade().getTradeNo());
                if (StringUtils.isNotBlank((CharSequence)aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment())) {
                    payStatusVO.setPayTime(DateTool.string2Date((String)aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
    }

    public Boolean findThirdPayStatus(String orderCode, int payFlg, int payType) {
        Boolean res = false;
        if (StringUtils.isNotBlank((CharSequence)orderCode)) {
            AliPayVO aliPayVO;
            if (payType == 1) {
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode, payFlg);
                res = this.ifWeiXinPayStatus(weiXinVO);
            }
            if (payType == 2) {
                aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, payType);
                res = this.ifPayStatus(aliPayVO);
            }
            if (payType == 3) {
                aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, payType);
                res = this.ifPayStatus(aliPayVO);
            }
        }
        return res;
    }

    public Boolean findThirdPayStatus(String orderCode, int payFlg, Boolean isOverSea) {
        Boolean res = false;
        if (StringUtils.isNotBlank((CharSequence)orderCode)) {
            if (isOverSea.booleanValue()) {
                AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 3);
                res = this.ifPayStatus(aliPayVO);
            } else if (payFlg == 1) {
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode, payFlg);
                res = this.ifWeiXinPayStatus(weiXinVO);
                if (!res.booleanValue()) {
                    AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 2);
                    res = this.ifPayStatus(aliPayVO);
                }
            } else if (payFlg == 3) {
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode, payFlg);
                res = this.ifWeiXinPayStatus(weiXinVO);
                if (!res.booleanValue()) {
                    AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 2);
                    res = this.ifPayStatus(aliPayVO);
                }
            } else {
                WeiXinVO weiXinVO = WeiXinPayUtil.findPayMementByOrder(orderCode, payFlg);
                res = this.ifWeiXinPayStatus(weiXinVO);
                if (!res.booleanValue()) {
                    AliPayVO aliPayVO = AliPayUtil.findPayMementByOrder(orderCode, 2);
                    res = this.ifPayStatus(aliPayVO);
                }
            }
        }
        return res;
    }

    private Boolean ifWeiXinPayStatus(WeiXinVO weiXinVO) {
        Boolean re = false;
        if (null != weiXinVO && "SUCCESS".equals(weiXinVO.getResultCode())) {
            if ("SUCCESS".equals(weiXinVO.getTradeState())) {
                re = true;
            } else {
                this.log.info("\u67e5\u8be2\u5fae\u4fe1tradeStat ={}", (Object)weiXinVO.getTradeState());
            }
        } else {
            System.out.println("\u67e5\u8be2\u5fae\u4fe1\u8fd4\u56de\u5f02\u5e38e={}" + weiXinVO);
            this.log.info("\u67e5\u8be2\u5fae\u4fe1\u8fd4\u56de\u5f02\u5e38e={}", (Object)weiXinVO);
        }
        return re;
    }

    private Boolean ifPayStatus(AliPayVO aliPayVO) {
        Boolean re = false;
        if (null != aliPayVO && "T".equals(aliPayVO.getIsSuccess())) {
            if (CollectionUtils.isNotEmpty(aliPayVO.getResponseVO()) && aliPayVO.getResponseVO().get(0).getTrade() != null) {
                System.out.println(aliPayVO.getResponseVO().get(0).getTrade().getRefundStatus() + "|" + aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus());
                if (aliPayVO.getResponseVO().get(0).getTrade().getRefundStatus() == null && ("TRADE_FINISHED".equals(aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus()) || "TRADE_SUCCESS".equals(aliPayVO.getResponseVO().get(0).getTrade().getTradeStatus()))) {
                    System.out.println(aliPayVO.getResponseVO().get(0).getTrade().getOutTradeNo() + "|" + aliPayVO.getResponseVO().get(0).getTrade().getTradeNo() + "|" + aliPayVO.getResponseVO().get(0).getTrade().getGmtPayment() + "|" + aliPayVO.getResponseVO().get(0).getTrade().getTotalFee());
                    re = true;
                }
            }
        } else {
            System.out.println("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8fd4\u56de\u5f02\u5e38e={}" + aliPayVO);
            this.log.info("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8fd4\u56de\u5f02\u5e38e={}", (Object)aliPayVO);
        }
        return re;
    }
}

