/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.thebeastshop.pegasus.integration.oss.MimeType;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OssUtil {
    private final Logger log = LoggerFactory.getLogger(OssUtil.class);
    @Value(value="${accessKeyId}")
    private String accessKeyId;
    @Value(value="${accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${endpoint}")
    private String endpoint;
    @Value(value="${bucketName}")
    private String bucketName;
    private final String KEY_IMG = "image/";
    private static final String KEY_PDF = "pdf/";
    private static final String KEY_FILE = "document/";
    private ClientConfiguration conf = new ClientConfiguration();

    private OssUtil() {
        this.conf.setMaxConnections(1024);
        this.conf.setConnectionTimeout(50000);
        this.conf.setSocketTimeout(50000);
        this.conf.setMaxErrorRetry(3);
    }

    private OSSClient createClient() {
        return new OSSClient("http://" + this.endpoint, this.accessKeyId, this.accessKeySecret, this.conf);
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBaseUrl() {
        return "http://" + this.getBucketName() + "." + this.getEndpoint() + "/";
    }

    private void putObject(String key, InputStream content, ObjectMetadata meta) {
        PutObjectResult result = this.createClient().putObject(this.bucketName, key, content, meta);
        this.log.info("etag:" + result.getETag());
    }

    public String uploadImg(String filePath) throws FileNotFoundException {
        String suffix = "";
        int idx = filePath.lastIndexOf(".");
        if (idx != -1) {
            suffix = filePath.substring(idx + 1);
        }
        return this.uploadImg(suffix, new FileInputStream(new File(filePath)));
    }

    public String uploadImg(String suffix, InputStream content) {
        String fileName = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss") + StringUtil.getRandomString((int)6, (String)"0123456789");
        return this.uploadImg(fileName, suffix, content);
    }

    public String uploadImg(String fileName, String suffix, InputStream content) {
        String key = "image/" + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.putObject(key, content, meta);
        return key;
    }

    public String uploadPdf(String fileName, String suffix, InputStream content) {
        String key = KEY_PDF + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.putObject(key, content, meta);
        return key;
    }

    public void delete(String key) {
        this.createClient().deleteObject(this.bucketName, key);
    }

    public String uploadFile(String subdirectory, String fileName, String suffix, InputStream content) {
        String key = KEY_FILE + (EmptyUtil.isNotEmpty((String)subdirectory) ? subdirectory + File.separator : "") + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.putObject(key, content, meta);
        return key;
    }

    public OSSObject downloadByKey(String key) {
        return this.createClient().getObject(this.bucketName, key);
    }

    public OSSObject download(String key) {
        return this.createClient().getObject(this.bucketName, key);
    }
}

