/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.oss;

public enum MimeType {
    JPG("jpg", "image/jpeg"),
    JPEG("jpeg", "image/jpeg"),
    BMP("bmp", "image/bmp"),
    PNG("png", "image/png"),
    GIF("gif", "image/gif"),
    TIF("tif", "image/tiff"),
    TIFF("tiff", "image/tiff"),
    PDF("pdf", "application/pdf");

    private String name;
    private String contentType;

    private MimeType(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public static MimeType findByName(String name) {
        for (MimeType mimeType : MimeType.values()) {
            if (!mimeType.name.equalsIgnoreCase(name)) continue;
            return mimeType;
        }
        return null;
    }

    public static MimeType findByContentType(String contentType) {
        for (MimeType mimeType : MimeType.values()) {
            if (!mimeType.contentType.equalsIgnoreCase(contentType)) continue;
            return mimeType;
        }
        return null;
    }
}

