/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express.sf;

import com.thebeastshop.pegasus.integration.constants.ExpressTypeConstants;
import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.integration.express.RouteInfo;
import com.thebeastshop.pegasus.integration.express.sf.ws.CommonExpressServiceService;
import com.thebeastshop.pegasus.integration.express.sf.ws.IExpressService;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.XMLUtil;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.ws.BindingProvider;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Component
public class SFUtil {
    private static final Logger log = LoggerFactory.getLogger(SFUtil.class);
    private final Semaphore semaphore = new Semaphore(2);
    private ReentrantLock reentrantLock = new ReentrantLock();
    private volatile boolean canUse = true;
    private volatile int _MAX_THREAD_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    @Value(value="${usercode}")
    private String _SF_EXPRESS_USER_CODE;
    @Value(value="${checkword}")
    private String _SF_EXPRESS_PWD;
    @Value(value="${custid}")
    private String _SF_EXPRESS_CUSTID;
    @Value(value="${env}")
    private String env;
    private static final String _SF_EXPRESS_TYPE = "2";
    private static final String _SF_EXPRESS_PAY_TYPE = "1";
    private static final String _SF_RESPONSE_SUCC = "OK";
    private static final String _SF_RESPONSE_ERR = "ERR";
    private static final int _WS_CONNECTION_TIMEOUT = 3000;
    private static final int _WS_REQUEST_TIMEOUT = 3000;
    public static final int _BLOCKING_TIMEOUT = 20;
    public static final int _WAITING_TIMEOUT = 30;
    private static final String _BEAST_OFFICE_ADDRESS = new StringBuilder(100).append(" j_company='\u91ce\u517d\u6d3e\u82b1\u5e97'\n").append(" j_contact='LEA' j_tel='021-32580718,021-52991228' j_mobile=''\n").append(" j_province='\u4e0a\u6d77' j_city='\u4e0a\u6d77' j_county='\u957f\u5b81\u533a'\n").append(" j_address='\u6dee\u6d77\u897f\u8def'\n").append(" d_company=''\n").toString();

    public String orderZDService(PackageInfo packageInfo) {
        if (!this.canUse) {
            return null;
        }
        String expressOrderNo = packageInfo.getExpressOrderNo();
        StringBuilder xmlBuilder = new StringBuilder(512);
        String xml = xmlBuilder.append("<Request service='OrderZDService' lang='zh-CN'>\n").append("<Head>").append(this._SF_EXPRESS_USER_CODE).append("</Head>\n").append("<Body>\n").append("<OrderZD  orderid ='").append(packageInfo.getExpressOrderNo()).append("'\n").append("parcel_quantity='").append(packageInfo.getOrderNum()).append("'\n").append("/>\n").append("</Body></Request>").toString();
        try {
            String responseXml = this.getResponseXml(xml);
            System.out.println(Thread.currentThread().getName() + "response ok " + responseXml);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String result = (String)xpath.evaluate("/Response/Head", new InputSource(new ByteArrayInputStream(responseXml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
            if (StringUtils.equals((CharSequence)_SF_RESPONSE_SUCC, (CharSequence)result)) {
                String mailNo = XMLUtil.parseString((String)"/Response/Body/OrderZDResponse/OrderZDResponse/@mailno_zd", (String)responseXml);
                packageInfo.setChildrenExpressNo(mailNo);
                return mailNo;
            }
        }
        catch (Exception e) {
            this.setCanUse(true);
        }
        return null;
    }

    public String generateExpressNo(PackageInfo packageInfo) {
        if (!this.canUse) {
            return null;
        }
        String is_gen = "is_gen_bill_no='1'";
        String expressNo = null;
        String[] custAddrs = packageInfo.getCustAddr().split("-");
        if (StringUtils.isBlank((CharSequence)packageInfo.getCustAddr())) {
            custAddrs = new String[]{"", "", "", ""};
        }
        StringBuilder epOrderSkus = new StringBuilder();
        for (PackageSkuInfo sku : packageInfo.getSkus()) {
            epOrderSkus.append("<Cargo name='").append(sku.getSkuName()).append(" * ").append(sku.getSkuNum()).append("'").append(" currency='CNY' source_area='\u4e2d\u56fd' ").append("></Cargo>").append("\n");
        }
        if (CollectionUtils.isEmpty(packageInfo.getSkus())) {
            log.warn("{}", (Object)("sf-\u751f\u6210\u5355\u53f7\u63a5\u53e3-\u53d1\u9001cargo\u4e3a\u7a7a\uff0cpackageNo:" + packageInfo.getOrderNo()));
        }
        String d_province = custAddrs[1];
        String d_city = custAddrs[2];
        String d_district = custAddrs[3];
        String expressOrderNo = this.getUniqueOrderNo(packageInfo);
        packageInfo.setExpressOrderNo(expressOrderNo);
        StringBuilder xmlBuilder = new StringBuilder(512);
        String cusId = this.env.equals("test") ? this._SF_EXPRESS_CUSTID : packageInfo.getMonthlyAccount();
        String xml = xmlBuilder.append("<Request service='OrderService' lang='zh-CN'>\n").append("<Head>").append(this._SF_EXPRESS_USER_CODE).append("</Head>\n").append("<Body>\n").append("<Order orderid ='").append(expressOrderNo).append("'\n").append(is_gen).append(_BEAST_OFFICE_ADDRESS).append("d_contact='").append(packageInfo.getRecName()).append("' d_tel='' d_mobile='").append(packageInfo.getRecPhone()).append("'\n").append("d_province='").append(d_province).append("' d_city='").append(d_city).append("' d_county='").append(d_district).append("'\n").append("d_address='").append(packageInfo.getRecAddress()).append("'\n").append("express_type ='").append(ExpressTypeConstants.getSFExpressType(packageInfo.getExpressType())).append("'\n").append("custid ='").append(cusId).append("' ").append("\n").append("pay_method ='").append(_SF_EXPRESS_PAY_TYPE).append("'").append("\n").append(">\n").append(epOrderSkus.toString()).append("</Order>\n</Body></Request>").toString();
        try {
            String responseXml = this.getResponseXml(xml);
            System.out.println(Thread.currentThread().getName() + "response ok " + responseXml);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String result = (String)xpath.evaluate("/Response/Head", new InputSource(new ByteArrayInputStream(responseXml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
            if (StringUtils.equals((CharSequence)_SF_RESPONSE_SUCC, (CharSequence)result)) {
                String mailNo = XMLUtil.parseString((String)"/Response/Body/OrderResponse/@mailno", (String)responseXml);
                String originCode = XMLUtil.parseString((String)"/Response/Body/OrderResponse/@origincode", (String)responseXml);
                String destCode = XMLUtil.parseString((String)"/Response/Body/OrderResponse/@destcode", (String)responseXml);
                packageInfo.setDeliveryCode(mailNo);
                packageInfo.setOriginCode(originCode);
                packageInfo.setDestCode(destCode);
                return mailNo;
            }
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            this.setCanUse(true);
            return expressNo;
        }
        return expressNo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<RouteInfo> findRouteInfo(String mailNo, boolean fetch) {
        ArrayList<RouteInfo> routers = Collections.EMPTY_LIST;
        StringBuilder xmlBuilder = new StringBuilder(256);
        String xml = xmlBuilder.append("<Request service='RouteService' lang='zh-CN'>\n").append("<Head>").append(this._SF_EXPRESS_USER_CODE).append("</Head>\n").append("<Body>\n").append("<RouteRequest ").append(" tracking_type='1'").append(" method_type='1'").append(" tracking_number='").append(mailNo).append("'\n").append("></RouteRequest>\n").append("</Body></Request>").toString();
        String responseXml = this.getResponseXml(xml);
        try {
            String result = XMLUtil.parseString((String)"/Response/Head", (String)responseXml);
            if (!StringUtils.equals((CharSequence)_SF_RESPONSE_SUCC, (CharSequence)result)) return Collections.EMPTY_LIST;
            NodeList routeList = XMLUtil.parseNodeList((String)"/Response/Body/RouteResponse/Route", (String)responseXml);
            if (routeList == null) return routers;
            routers = new ArrayList<RouteInfo>();
            for (int i = 0; i < routeList.getLength(); ++i) {
                Node node = routeList.item(i);
                NamedNodeMap attributes = node.getAttributes();
                RouteInfo router = new RouteInfo();
                router.setAcceptAddress(this.getNodeValue(attributes.getNamedItem("accept_address")));
                router.setAcceptTime(this.getNodeValue(attributes.getNamedItem("accept_time")));
                router.setOpcode(this.getNodeValue(attributes.getNamedItem("opcode")));
                router.setRemark(this.getNodeValue(attributes.getNamedItem("remark")));
                routers.add(router);
                if (!fetch) return routers;
            }
            return routers;
        }
        catch (XPathExpressionException e) {
            this.setCanUse(true);
        }
        return routers;
    }

    @Deprecated
    private String findOrderInfo(String expressOrderNo) {
        if (StringUtils.isBlank((CharSequence)expressOrderNo)) {
            return null;
        }
        StringBuilder xmlBuilder = new StringBuilder(128);
        String xml = xmlBuilder.append("<Request service='OrderSearchService' lang='zh-CN'>\n").append("<Head>BSPdevelop</Head>\n").append("<Body>\n").append("<OrderSearch orderid ='").append(expressOrderNo + "' \n").append("></OrderSearch>\n").append("</Body></Request>").toString();
        try {
            String responseXml = this.getResponseXml(xml);
            String result = XMLUtil.parseString((String)"/Response/Head", (String)responseXml);
            if (StringUtils.equals((CharSequence)_SF_RESPONSE_SUCC, (CharSequence)result)) {
                return XMLUtil.parseString((String)"/Response/Body/OrderResponse/@mailno", (String)responseXml);
            }
        }
        catch (Exception e) {
            this.setCanUse(true);
            return null;
        }
        return null;
    }

    public String getNodeValue(Node node) {
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> generateExpressNo(List<PackageInfo> packageInfos) {
        if (CollectionUtils.isNotEmpty(packageInfos)) {
            try {
                this.semaphore.tryAcquire(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new IntegrationException("IG1001", "\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
            try {
                ExecutorService executor = Executors.newFixedThreadPool(this._MAX_THREAD_SIZE);
                for (PackageInfo packageInfo : packageInfos) {
                    executor.execute(new SFExpressNoTask(packageInfo));
                }
                executor.shutdown();
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
            }
            finally {
                this.semaphore.release();
                this.setCanUse(true);
            }
        } else {
            return Collections.EMPTY_MAP;
        }
        return Collections.EMPTY_MAP;
    }

    private IExpressService createSFService() {
        if (!this.canUse) {
            return null;
        }
        URL url = null;
        Object e = null;
        try {
            url = CommonExpressServiceService.class.getClassLoader().getResource("pegasus-integration/wsdl/" + this.env + "/sfexpress.wsdl");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        IExpressService service = new CommonExpressServiceService(url).getCommonExpressServicePort();
        ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", 3000);
        ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", 3000);
        return service;
    }

    private String getUniqueOrderNo(PackageInfo packageInfo) {
        StringBuilder orderNo = new StringBuilder(64);
        orderNo.append(packageInfo.getOrderNo());
        orderNo.append(DateUtil.format((Date)DateUtil.getNow(), (String)"yyyyMMddHHmmss"));
        return orderNo.toString();
    }

    private String getResponseXml(String xml) {
        return this.createSFService().sfexpressService(xml, Base64.encodeBase64String((byte[])DigestUtils.md5((String)(xml + this._SF_EXPRESS_PWD))));
    }

    public boolean isCanUse() {
        return this.canUse;
    }

    public void setCanUse(boolean canUse) {
        this.canUse = canUse;
    }

    class SFExpressNoTask
    implements Runnable {
        private PackageInfo packageInfo;

        public SFExpressNoTask(PackageInfo packageInfo) {
            this.packageInfo = packageInfo;
        }

        @Override
        public void run() {
            SFUtil.this.generateExpressNo(this.packageInfo);
        }
    }
}

