/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration.express.exfresh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.integration.express.exfresh.ExFreshOrder;
import com.thebeastshop.pegasus.integration.express.exfresh.ExFreshOrderPackage;
import com.thebeastshop.pegasus.integration.express.exfresh.ExFreshResp;
import com.thebeastshop.pegasus.integration.express.exfresh.IdWorker;
import com.thebeastshop.pegasus.integration.express.exfresh.OrderItem;
import com.thebeastshop.pegasus.integration.express.exfresh.UserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.UUID;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExFreshUtil {
    private static final Logger log = LoggerFactory.getLogger(ExFreshUtil.class);
    private static ExFreshUtil instance = new ExFreshUtil();
    private static String AppId;
    private static String AppSecret;
    private static String reqUrl;
    private static final IdWorker deliveryCodeGen;

    private ExFreshUtil() {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/express/exfresh");
        AppId = config.getString("AppId");
        AppSecret = config.getString("AppSecret");
        reqUrl = config.getString("reqUrl");
    }

    public static ExFreshUtil getInstance() {
        return instance;
    }

    public boolean submitOrder(PackageInfo packageInfo) {
        ExFreshOrder order = this.buildOrderFromPackageInfo(packageInfo);
        boolean result = false;
        try {
            result = this.sendReqExFresh(order);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private ExFreshOrder buildOrderFromPackageInfo(PackageInfo packageInfo) {
        ExFreshOrder exOrder = new ExFreshOrder();
        exOrder.setCustomerName(packageInfo.getRecName());
        exOrder.setChannelType("303");
        exOrder.setCustomerId("2063EA1D-A666-4172-AE89-1D5DB8FFAC18");
        exOrder.setUserInfo(this.buildUserInfo());
        ArrayList<ExFreshOrderPackage> packageList = new ArrayList<ExFreshOrderPackage>();
        packageList.add(this.buildExFreshOrderPackageInfo(packageInfo));
        exOrder.setOrderPackageList(packageList);
        return exOrder;
    }

    private ExFreshOrderPackage buildExFreshOrderPackageInfo(PackageInfo packageInfo) {
        ExFreshOrderPackage info = new ExFreshOrderPackage();
        info.setCustomerName(packageInfo.getCustName());
        packageInfo.setDeliveryCode(deliveryCodeGen.nextId() + "");
        info.setOutOrderCode(packageInfo.getDeliveryCode());
        info.setDeliveryDateStart(packageInfo.getPlanedDeliveryDate());
        info.setDeliveryDateEnd(packageInfo.getPlanedDeliveryDate());
        info.setPaymentMethod(null);
        info.setSender("\u91ce\u517d\u6d3e");
        info.setSenderTel(this.findSenderTel(packageInfo.getChannelCode()));
        info.setSenderAddress(packageInfo.getWarehouseAddress());
        info.setProductTotalAmount(packageInfo.getPaySum().toString());
        info.setTotalPrice(packageInfo.getPaySum().toString());
        info.setPaymentAmount(packageInfo.getPaySum().toString());
        info.setReceiver(packageInfo.getRecName());
        info.setReceiverTel(packageInfo.getRecPhone());
        info.setReceiverMobile(null);
        info.setReceiverProvince(packageInfo.getCustProvince());
        info.setReceiverCity(packageInfo.getCustCity());
        info.setReceiverAddress(packageInfo.getRecAddress());
        info.setReceiverDistrict(packageInfo.getCustDistrict());
        info.setRemark(packageInfo.getRemark());
        info.setOutPackageNumber(packageInfo.getDeliveryCode());
        info.setDeliveryStationCode(null);
        info.setDriverName(null);
        info.setOtsCustomerId(null);
        info.setSenderProvince(packageInfo.getWarehouseProvince());
        info.setSenderCity(packageInfo.getWarehouseCity());
        info.setSenderAddress(packageInfo.getWarehouseAddress());
        info.setSenderDistrict(packageInfo.getWarehouseDistrict());
        info.setAreaId(null);
        info.setDistrictId(null);
        info.setAreaCode(null);
        info.setPaymentId(null);
        info.setOrderSource(6);
        info.setDeliveryMobile(null);
        info.setLat(null);
        info.setLng(null);
        info.setDeliveryType(1);
        info.setDistributorId("00000000-0000-0000-0000-000000000000");
        info.setDistrictId(null);
        info.setSourceType(1);
        info.setTotalCount(packageInfo.getOrderNum());
        info.setOrderTitle("\u8fd0\u5355\u7ba1\u7406\u9879\u76ee\u5355\u5143\u6d4b\u8bd5");
        info.setShopId("00000000-0000-0000-0000-000000000000");
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        for (PackageSkuInfo skuInfo : packageInfo.getSkus()) {
            OrderItem item = new OrderItem();
            item.setPackageNum(skuInfo.getSkuNum() + "");
            item.setPackageTitle(this.getPackageTitle(skuInfo));
            item.setPackageWeight("0");
            item.setTotalAmount(1000);
            item.setShopId("00000000-0000-0000-0000-000000000000");
            orderItems.add(item);
        }
        info.setOrderItems(orderItems);
        return info;
    }

    private String findSenderTel(String channelCode) {
        if ("CHN1031".equals(channelCode) || "CHN2042".equals(channelCode) || "CHN2046".equals(channelCode)) {
            return "021-52991228";
        }
        return "400-9200-108";
    }

    private String getPackageTitle(PackageSkuInfo skuInfo) {
        return skuInfo.getCategoryName();
    }

    private UserInfo buildUserInfo() {
        UserInfo userInfo = new UserInfo();
        UUID uuid = UUID.randomUUID();
        userInfo.setLoginToken(uuid.toString());
        userInfo.setLoginIpAddress("172.17.17.154");
        return userInfo;
    }

    private boolean sendReqExFresh(ExFreshOrder order) throws IOException, HttpException {
        PostMethod method = new PostMethod(reqUrl);
        method.setRequestHeader("AppId", AppId);
        method.setRequestHeader("AppSecret", AppSecret);
        String json = JSONObject.toJSONString((Object)order);
        StringRequestEntity entity = new StringRequestEntity(json, "application/json", "UTF-8");
        method.setRequestEntity((RequestEntity)entity);
        HttpClient client = new HttpClient();
        int status = client.executeMethod((HttpMethod)method);
        if (status == 200) {
            String str = method.getResponseBodyAsString();
            ExFreshResp resp = (ExFreshResp)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)str), ExFreshResp.class);
            return resp.isSuccess();
        }
        return false;
    }

    static {
        deliveryCodeGen = new IdWorker(0L, 0L);
    }
}

