/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.integration;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringUtil
implements ApplicationContextAware,
InitializingBean {
    private static Map<String, WeakReference<ApplicationContext>> contextMap_ = new HashMap<String, WeakReference<ApplicationContext>>();
    private String currentKey_;
    private ApplicationContext currentContext_;

    public static Object getBean(String beanName) {
        ApplicationContext context = (ApplicationContext)contextMap_.get("mainContext").get();
        return context != null ? context.getBean(beanName) : null;
    }

    public static <T> T getBean(Class<T> requiredType) {
        ApplicationContext context = (ApplicationContext)contextMap_.get("mainContext").get();
        return (T)context.getBean(requiredType);
    }

    public static ApplicationContext getContext(String key) {
        return (ApplicationContext)contextMap_.get(key).get();
    }

    public static Iterator<ApplicationContext> getContextIterator() {
        return new ReferenceIteratorWrapper<ApplicationContext>(contextMap_.values().iterator());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.currentContext_ = applicationContext;
    }

    public String getContextKey() {
        return this.currentKey_;
    }

    public void setContextKey(String contextKey) {
        this.currentKey_ = contextKey;
    }

    public void afterPropertiesSet() throws BeanInitializationException {
        if (this.currentKey_ == null) {
            throw new BeanInitializationException("Property 'contextKey' is required.");
        }
        contextMap_.put(this.currentKey_, new WeakReference<ApplicationContext>(this.currentContext_));
        this.currentKey_ = null;
        this.currentContext_ = null;
    }

    public static String bigdecimalScal(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return String.valueOf(b.divide(one, scale, 4).doubleValue());
    }

    private static class ReferenceIteratorWrapper<T>
    implements Iterator<T> {
        private Iterator<? extends Reference<T>> iterator_;

        public ReferenceIteratorWrapper(Iterator<? extends Reference<T>> iterator) {
            this.iterator_ = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator_.hasNext();
        }

        @Override
        public T next() {
            return this.iterator_.next().get();
        }

        public T nextNotNull() {
            while (this.iterator_.hasNext()) {
                T t = this.iterator_.next().get();
                if (t == null) continue;
                return t;
            }
            return null;
        }

        @Override
        public void remove() {
            this.iterator_.remove();
        }
    }
}

