/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.sms;

import com.thebeastshop.pegasus.sms.cond.SmsSendLogCond;
import com.thebeastshop.pegasus.sms.model.SmsSendLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.thebeastshop.pegasus.integration.sms.service.SmsService;
import com.thebeastshop.pegasus.integration.sms.service.impl.BeanliSmsServiceImpl;

import java.util.List;

/**
 * @author Royan
 * @version $Id: SmsUtil.java, v 0.1 2015-08-13 下午4:57
 */
public class SmsUtil {

    private final Logger         log        = LoggerFactory.getLogger(SmsUtil.class);

    private static final SmsUtil instance   = new SmsUtil();

    private static SmsService    smsService = new BeanliSmsServiceImpl();

    private SmsUtil() {
    }

    public static SmsUtil getInstance() {
        return instance;
    }

    public boolean send(SmsVO smsVO) {
        return smsService.send(smsVO);
    }

    public List<SmsSendLog> checkSendLog(SmsSendLogCond cond){
        return smsService.checkSendLog(cond);
    }
    //    public static void main(String[] args) throws Exception {
    //        List<String> mobileList = new ArrayList<>();
    //        mobileList.add("18017233379");
    //        mobileList.add("13671762745");
    //        mobileList.add("13585590312");
    //
    //        Map<String, Object> params = new HashMap();
    //        params.put("passwd", "111111");
    //        String content = SmsTemplateUtil.fromTemplate("REGISTER_SUCCESS_IPOS", params);
    //        System.out.println(content);
    //        SmsVO smsVO = new SmsVO();
    //        smsVO.setContent(content);
    //        smsVO.setMobileList(mobileList);
    //        SmsUtil.getInstance().send(smsVO);
    //    }
}