package com.thebeastshop.pegasus.integration.pay.vo;


import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.*;
import java.io.Serializable;

/**
 * 微信返回的交易vo
 * create by com.thebeastshop.pegasus.integration.pay.vo trunk :author lijing
 * User:lijing
 * DATE : 2017/5/3
 * TIME : 13:32
 * trunk.
 */
@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name = "xml")
public class WeiXinVO implements Serializable {

    /**返回状态码*/
    @XmlElement(name = "return_code")
    private String returnCode;

    /**返回信息*/
    @XmlElement(name = "return_msg")
    private String returnMsg;
    /**公众账号ID*/
    @XmlElement(name = "return_msg")
    private String appId;
    /**商户号*/
    @XmlElement(name = "mch_id")
    private String mchId;
    /**随机字符串*/
    @XmlElement(name = "nonce_str")
    private String nonceStr;
    /**签名*/
    @XmlElement(name = "sign")
    private String sign;
    /**业务结果 SUCCESS/FAIL*/
    @XmlElement(name = "result_code")
    private String resultCode;
    /**错误代码 */
    @XmlElement(name = "err_code")
    private String errCode;
    /**错误代码描述*/
    @XmlElement(name = "err_code_des")
    private String errCodeDes;
    /**设备号*/
    @XmlElement(name = "device_info")
    private String deviceInfo;
    /**openId*/
    @XmlElement(name = "openid")
    private String openId;
    /**是否关注公众账号*/
    @XmlElement(name = "is_subscribe")
    private String isSubscribe;

    /**交易类型*/
    @XmlElement(name = "trade_type")
    private String tradeType;

    /**交易类型*/
    @XmlElement(name = "trade_state")
    private String tradeState;
    /**付款银行*/
    @XmlElement(name = "bank_type")
    private String bankType;
    /**标价金额*/
    @XmlElement(name = "total_fee")
    private int totalFee;
    /**应结订单金额*/
    @XmlElement(name = "settlement_total_fee")
    private int settlementTotalFee;
    /**标价 币种*/
    @XmlElement(name = "fee_type")
    private String feeType;

    /**现金支付金额*/
    @XmlElement(name = "cash_fee")
    private Integer cashFee;
    /**现金支付币种*/
    @XmlElement(name = "cash_fee_type")
    private String cashFeeType;

    /**微信支付订单号*/
    @XmlElement(name = "transaction_id")
    private String transactionId;
    /**商户订单号*/
    @XmlElement(name = "out_trade_no")
    private String outTradeNo;
    /**支付完成时间*/
    @XmlElement(name = "time_end")
    private String timeEnd;

    /**交易状态描述*/
    @XmlElement(name = "trade_state_desc")
    private String tradeStateDesc;

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrCodeDes() {
        return errCodeDes;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getIsSubscribe() {
        return isSubscribe;
    }

    public void setIsSubscribe(String isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getTradeState() {
        return tradeState;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public String getBankType() {
        return bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public int getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    public int getSettlementTotalFee() {
        return settlementTotalFee;
    }

    public void setSettlementTotalFee(int settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public Integer getCashFee() {
        return cashFee;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public String getCashFeeType() {
        return cashFeeType;
    }

    public void setCashFeeType(String cashFeeType) {
        this.cashFeeType = cashFeeType;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getTimeEnd() {
        return timeEnd;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public String getTradeStateDesc() {
        return tradeStateDesc;
    }

    public void setTradeStateDesc(String tradeStateDesc) {
        this.tradeStateDesc = tradeStateDesc;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("returnCode", returnCode)
                .append("returnMsg", returnMsg)
                .append("appId", appId)
                .append("mchId", mchId)
                .append("nonceStr", nonceStr)
                .append("sign", sign)
                .append("resultCode", resultCode)
                .append("errCode", errCode)
                .append("errCodeDes", errCodeDes)
                .append("deviceInfo", deviceInfo)
                .append("openId", openId)
                .append("isSubscribe", isSubscribe)
                .append("tradeType", tradeType)
                .append("tradeState", tradeState)
                .append("bankType", bankType)
                .append("totalFee", totalFee)
                .append("settlementTotalFee", settlementTotalFee)
                .append("feeType", feeType)
                .append("cashFee", cashFee)
                .append("cashFeeType", cashFeeType)
                .append("transactionId", transactionId)
                .append("outTradeNo", outTradeNo)
                .append("timeEnd", timeEnd)
                .append("tradeStateDesc", tradeStateDesc)
                .toString();
    }
}
