package com.thebeastshop.pegasus.integration.pay.util;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

/**
 * xml的工具
 * create by com.thebeastshop.pegasus.integration.pay.util trunk :author lijing
 * User:lijing
 * DATE : 2017/4/28
 * TIME : 15:26
 * trunk.
 */
public class XMLBeanUtil {

    public static String toXml(Object obj) throws Exception {
        String xml = "";
        JAXBContext context = JAXBContext.newInstance(obj.getClass());
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        marshaller.marshal(obj, os);
        xml = os.toString();
        return xml;
    }

    @SuppressWarnings("unchecked")
    public static <T> T toObject(String xml, Class<T> clazz) throws Exception {
        T obj = null;
        JAXBContext context = JAXBContext.newInstance(clazz);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        byte[] buf = xml.getBytes("UTF-8");
        obj = (T) unmarshaller.unmarshal(new ByteArrayInputStream(buf));
        return obj;
    }
}
