package com.thebeastshop.pegasus.integration.pay;

import com.thebeastshop.pegasus.integration.constants.PayThirdConstants;
import com.thebeastshop.pegasus.integration.pay.util.MD5Util;
import com.thebeastshop.pegasus.integration.pay.util.WeiXinPayHttpUtil;
import com.thebeastshop.pegasus.integration.pay.util.XMLBeanUtil;
import com.thebeastshop.pegasus.integration.pay.vo.WeiXinVO;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;

/**
 * 微信支付查询接口
 * create by com.thebeastshop.pegasus.integration.pay trunk :author lijing
 * User:lijing
 * DATE : 2017/5/4
 * TIME : 10:51
 * trunk.
 */
public class WeiXinPayUtil {
    /**日志*/
    private final static Logger logger = LoggerFactory.getLogger(WeiXinPayUtil.class);

    public static WeiXinVO findPayMementByOrder(String orderCode,int payFlg){
        return handleParam(orderCode,payFlg);
    }

    public static void main(String[] args) {
        WeiXinVO w= WeiXinPayUtil.findPayMementByOrder("SO0120180001900991",2);
        System.out.println(w);
    }
    /**
     * 发送请求并返会vo
     * @param orderCode
     * @param isApp
     * @return
     */
   private static WeiXinVO handleParam(String orderCode,int payFlg){
       WeiXinVO weiXinVO = null;
       try{
           //得到访问参数
            TreeMap<String,String> param = convertParamMap(orderCode,payFlg);
           //把map参数包装成xml
           String xmlStringParam = convertXmlString(param);
           //发送请求
           String resultR =  WeiXinPayHttpUtil.sendPostWei(xmlStringParam);
           //转换vo
           if(StringUtils.isNotBlank(resultR)) {
               weiXinVO = XMLBeanUtil.toObject(resultR,WeiXinVO.class);
           }
       }catch (Exception e){
           logger.error("微信查询接口异常 e={}",e);
       }
       return weiXinVO;
   }

   /**
    * 
    * @param orderCode
    * @param payFlg 1:app,2:webfront,3:ipos
    * @return 
    */
    private static TreeMap<String,String> convertParamMap(String orderCode,int payFlg){
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        if(payFlg==1){
            treeMap.put("appid", PayThirdConstants.WEI_XIN_PAY_CONFIG_APP.app_id);
            treeMap.put("mch_id", PayThirdConstants.WEI_XIN_PAY_CONFIG_APP.mch_id);
            treeMap.put("nonce_str", getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        }else if(payFlg == 3){
            treeMap.put("appid", PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.app_id);
            treeMap.put("mch_id", PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.mch_id);
            treeMap.put("nonce_str", getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        }else{
            treeMap.put("appid", PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.app_id);
            treeMap.put("mch_id", PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.mch_id);
            treeMap.put("nonce_str", getNonceStr());
            treeMap.put("out_trade_no", orderCode);
        }
        treeMap.put("sign", getSign(treeMap,payFlg));
        return treeMap;
    }

    /**
     * 将参数拼成xml
     * @param args
     * @return
     */
    private static String convertXmlString(TreeMap<String,String> args){
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>\n");
        for (Map.Entry<String, String> entry : args.entrySet()) {
            xml.append("<" + entry.getKey() + ">").append(entry.getValue()).append("</" + entry.getKey() + ">\n");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    /**得到随机数*/
    private static String getNonceStr(){
        return MD5Util.MD5( System.currentTimeMillis()+"");
    }

    /**
     * 得到签名
     * @param args 参数
     * @param isApp 是否是app 不是这是pc
     * @return
     */
    private static String getSign(TreeMap<String,String> args,int payFlg){
        String res = "";
        String stringA="appid="+args.get("appid")+"&mch_id="+args.get("mch_id")+"&nonce_str="+args.get("nonce_str")+"&out_trade_no="+args.get("out_trade_no");
        if(payFlg==1){
            String stringSignTemp=stringA+"&key="+PayThirdConstants.WEI_XIN_PAY_CONFIG_APP.key;
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        }else if(payFlg ==3){
            String stringSignTemp=stringA+"&key="+PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.key;
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        }else{
            String stringSignTemp=stringA+"&key="+PayThirdConstants.WEI_XIN_PAY_CONFIG_PC.key;
            res = MD5Util.MD5(stringSignTemp).toUpperCase();
        }
        return  res;
    }

    public static String getSign(Object object, String key) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : getSortedValueMap(object).entrySet()) {
            builder.append(entry.getKey()).append('=').append(entry.getValue()).append('&');
        }
        builder.append("key=").append(key);
        return DigestUtils.md5Hex(builder.toString());
    }

    private static Map<String, String> getSortedValueMap(Object object) throws Exception {
        Map<String, String> map = new TreeMap<>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String value = field.get(object).toString();
            if (StringUtils.isNotEmpty(value)) {
                map.put(field.getName(), value);
            }
        }
        return map;
    }

    public static String sendToWX(HttpPost httpPost, String data) throws IOException {
        StringEntity entity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.setEntity(entity);
        // httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(50).setConnectTimeout(50).setSocketTimeout(50).build());
        return EntityUtils.toString(HttpClients.createDefault().execute(httpPost).getEntity(), "UTF-8");
    }
}
