/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;

/**
 * @author Royan
 * @version $Id: OssUtil.java, v 0.1 2015-08-14 下午1:15
 */
@Component
public class OssUtil {

    private final Logger log = LoggerFactory.getLogger(OssUtil.class);

    @Value("${accessKeyId}")
    private String accessKeyId;
    @Value("${accessKeySecret}")
    private String accessKeySecret;
    @Value("${endpoint}")
    private String endpoint;
    @Value("${bucketName}")
    private String bucketName;
    private final String KEY_IMG = "image/";
    private static final String KEY_PDF = "pdf/";
    private static final String KEY_FILE = "document/";
    private ClientConfiguration conf;

    private OssUtil() {
        conf = new ClientConfiguration();
        // 设置HTTP最大连接数为1024
        conf.setMaxConnections(1024);
        // 设置TCP连接超时为50000毫秒
        conf.setConnectionTimeout(50000);
        // 设置Socket传输数据超时的时间为50000毫秒
        conf.setSocketTimeout(50000);
        // 设置最大的重试次数为3
        conf.setMaxErrorRetry(3);
    }

    private OSSClient createClient() {
        return new OSSClient("http://" + endpoint, accessKeyId, accessKeySecret, conf);
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBaseUrl() {
        return "http://" + getBucketName() + "." + getEndpoint() + "/";
    }

    private void putObject(String key, InputStream content, ObjectMetadata meta) {
        // 上传Object
        PutObjectResult result = createClient().putObject(bucketName, key, content, meta);

        // 打印ETag
        log.info("etag:" + result.getETag());
    }

    public String uploadImg(String filePath) throws FileNotFoundException {
        String suffix = "";
        int idx = filePath.lastIndexOf(".");
        if (idx != -1) {
            suffix = filePath.substring(idx + 1);
        }

        return uploadImg(suffix, new FileInputStream(new File(filePath)));
    }

    public String uploadImg(String suffix, InputStream content) {
        String fileName = DateUtil.format(new Date(), "yyyyMMddHHmmss")
                + StringUtil.getRandomString(6, StringUtil.randomInts);

        return uploadImg(fileName, suffix, content);
    }

    public String uploadImg(String fileName, String suffix, InputStream content) {
        String key = KEY_IMG + fileName + "." + suffix;

        // 创建上传Object的Metadata
        ObjectMetadata meta = new ObjectMetadata();

        // 必须设置ContentLength
        //        meta.setContentLength(file.length());

        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }

        putObject(key, content, meta);

        return key;
    }
    
    public String uploadPdf(String fileName, String suffix, InputStream content) {
        String key = KEY_PDF + fileName + "." + suffix;

        // 创建上传Object的Metadata
        ObjectMetadata meta = new ObjectMetadata();

        // 必须设置ContentLength
        //        meta.setContentLength(file.length());

        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }

        putObject(key, content, meta);

        return key;
    }

    public void delete(String key) {
        createClient().deleteObject(bucketName, key);
    }


    public String uploadFile(String subdirectory,String fileName, String suffix, InputStream content) {

        String key = KEY_FILE + (EmptyUtil.isNotEmpty(subdirectory) ? (subdirectory + File.separator) : "") + fileName + "." + suffix;
        // 创建上传Object的Metadata
        ObjectMetadata meta = new ObjectMetadata();
        // 必须设置ContentLength
        //        meta.setContentLength(file.length());

        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }

        putObject(key, content, meta);

        return key;
    }

    public OSSObject downloadByKey(String key) {
        return createClient().getObject(bucketName, key);
    }

//    public static void main(String[] args) throws Exception {
//        String key = OssUtil.getInstance().uploadImg("jpg",
//                new FileInputStream(new File("C:/Users/Administrator/Desktop/111.jpg")));
//        System.out.println(OssUtil.getInstance().getBaseUrl() + key);
//        OssUtil.getInstance().delete(key);
//    }

    public OSSObject download(String key) {
       return createClient().getObject(bucketName, key);
    }
}