package com.thebeastshop.pegasus.integration.express.zt;

import com.google.gson.Gson;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by admin on 2016/12/7.
 */
public class ZTExpressUtil implements Serializable {
    public static ZTResponse getRouteInfo(String orderNo){

        try {
            String data = "[\"" + orderNo + "\"]";
            Map map = new HashMap();
            map.put("data", data);
            map.put("msg_type", "NEW_TRACES");
            map.put("data_digest", DigestUtil.digest(data, "4F086D04A3C5D81E37BAF641EEA8E28E", DigestUtil.UTF8));
            map.put("company_id", "da383a0c6bfe4bbc9af85dcd5eb06572");
            String response = HttpUtil.post("http://japi.zto.cn/zto/api_utf8/traceInterface", "UTF-8", map);
            Gson gson = new Gson();
//            JSONObject obj = new JSONObject().fromObject(response);
            ZTResponse jb = gson.fromJson(response, ZTResponse.class);
//            System.out.println(jb.getData().get(0).getTraces().get(0).getDesc());
            return  jb;
        } catch (Exception e) {
//            e.printStackTrace();
        }
        return null;
    }
    public static ZTOrderSubmitResponse submitOrder(ZTOrder ztOrder,Long packageId){
        String url = "http://partner.zto.cn/client/interface.php";
        JSONObject json = JSONObject.fromObject(ztOrder);//将java对象转换为json对象
        String data = json.toString();
        Map<String, Object> map = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String datetime = sdf.format(new Date());

        try {
            String content = DigestUtil.encryptBASE64(data);
            map.put("content", content);
            map.put("style", "json");
            map.put("func", "order.submit");
            map.put("partner", "ZTO_1001137592");
            map.put("datetime", datetime);
            map.put("verify", DigestUtil.digest("ZTO_1001137592" , datetime , content , "Y8RZ4UBC29"));
            String res = HttpUtil.post(url, "utf-8", map);
            System.out.println(res);
            Gson gson = new Gson();
            ZTOrderSubmitResponse jb = gson.fromJson(res, ZTOrderSubmitResponse.class);
            jb.getKeys().setPackageId(packageId);
            return jb;
        } catch (Exception e) {
//            e.printStackTrace();
        }
        return null;
    }
}
