package com.thebeastshop.pegasus.integration.express.zt;

import com.google.gson.Gson;
import net.sf.json.JSONObject;
import sun.net.www.protocol.http.HttpURLConnection;

import java.io.*;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by admin on 2016/12/2.
 */
public class HttpUtil {
    /**
     * 发送POST 请求
     * @param url 请求地址
     * @param charset 编码格式
     * @param params 请求参数
     * @return 响应
     * @throws IOException
     */
    public static String post(String url, String charset, Map params) throws IOException {
        HttpURLConnection conn = null;
        OutputStreamWriter out = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Accept-Charset", charset);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");

            out = new OutputStreamWriter(conn.getOutputStream(), charset);
            out.write(buildQuery(params, charset));
            out.flush();
            inputStream = conn.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            reader = new BufferedReader(inputStreamReader);
            String tempLine = null;
            while ((tempLine = reader.readLine()) != null) {
                result.append(tempLine);
            }

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                out.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result.toString();
    }

    /**
     * 将map转换为请求字符串
     * <p>data=xxx&msg_type=xxx</p>
     * @param params
     * @param charset
     * @return
     * @throws IOException
     */
    public static String buildQuery(Map<String, Object> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }

        StringBuffer data = new StringBuffer();
        boolean flag = false;

        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (flag) {
                data.append("&");
            } else {
                flag = true;
            }
            data.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), charset));
        }
        System.out.println(data.toString());
        return data.toString();

    }

    public static void main(String[] args) throws Exception {
        ZTOrder ztOrder = new ZTOrder();
        ztOrder.setId("1111");
        ztOrder.setTypeid("1");
        ztOrder.setType("电子面单");
        ztOrder.setRemark("备注");
        ZTSender sender = new ZTSender();
        sender.setAddress("淮西西路570号");
        sender.setCity("上海市,上海市,长宁区");
        sender.setCompany("野兽派");
        sender.setMobile("15000000000");
        sender.setName("野兽派");
        sender.setZipcode("200000");
        ztOrder.setSender(sender);
        ZTReceiver ztReceiver = new ZTReceiver();
        ztReceiver.setZipcode("200000");
        ztReceiver.setName("康利斌");
        ztReceiver.setMobile("15800506135");
        ztReceiver.setAddress("淮西西路570号");
        ztReceiver.setCity("上海市,上海市,长宁区");
        ztOrder.setReceiver(ztReceiver);
        ZTOrderSku[] sku = new ZTOrderSku[2];
        sku[0] = new ZTOrderSku();
        sku[1] = new ZTOrderSku();
        sku[0].setName("被子");
        sku[0].setQuantity(1);
        sku[1].setName("鲜花");
        sku[1].setQuantity(2);
        ztOrder.setItems(sku);
//        JSONObject json = JSONObject.fromObject(ztOrder);//将java对象转换为json对象
//        String data = json.toString();
//        System.out.println(data);
//        ZTExpressUtil.submitOrder(ztOrder);

        try {
//            ZTExpressUtil.submitOrder(ztOrder);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
