/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.express.yto;

import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.web.util.http.HttpRequest;
import com.thebeastshop.pegasus.web.util.http.HttpResponse;
import com.thebeastshop.pegasus.web.util.http.HttpUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URLEncoder;
import java.util.ResourceBundle;

/**
 * @author Royan
 * @version $Id: CreateOrder.java, v 0.1 2015-11-02 下午2:20
 */
public class YtoUtil {

    private final static Logger log      = LoggerFactory.getLogger(YtoUtil.class);

    private static YtoUtil      instance = new YtoUtil();
    private String              apiUrl;
    private String              parternId;
    private String              clientId;
    private String              customerId;

    private YtoUtil() {
        ResourceBundle config = ResourceBundle.getBundle("pegasus-integration/express/yto");
        apiUrl = config.getString("apiUrl");
        parternId = config.getString("parternId");
        clientId = config.getString("clientId");
        customerId = config.getString("customerId");
    }

    public static YtoUtil getInstance() {
        return instance;
    }

    public String createOrder(PackageInfo packageInfo) {
        String packageCode = "SO123456";

        try {
            //数据
            StringBuilder xmlBuilder = new StringBuilder();
            xmlBuilder.append("<RequestOrder>");
            xmlBuilder.append("    <clientID>" + clientId + "</clientID>");
            xmlBuilder.append("    <logisticProviderID>YTO</logisticProviderID>");
            xmlBuilder.append("    <customerId>" + customerId + "</customerId>");
            xmlBuilder.append("    <txLogisticID>" + clientId + packageCode + "</txLogisticID>");
            xmlBuilder.append("    <tradeNo>" + packageCode + "</tradeNo>");
            xmlBuilder.append("    <totalServiceFee>0</totalServiceFee>");
            xmlBuilder.append("    <codSplitFee>0</codSplitFee>");
            xmlBuilder.append("    <orderType>1</orderType>");
            xmlBuilder.append("    <serviceType>1</serviceType>");
            xmlBuilder.append("    <flag>0</flag>");
            xmlBuilder.append("    <sendStartTime></sendStartTime>");
            xmlBuilder.append("    <sendEndTime></sendEndTime>");
            xmlBuilder.append("    <goodsValue>1</goodsValue>");
            xmlBuilder.append("    <itemsValue>1</itemsValue>");
            xmlBuilder.append("    <insuranceValue>0</insuranceValue>");
            xmlBuilder.append("    <special></special>");
            xmlBuilder.append("    <remark></remark>");
            xmlBuilder.append("    <deliverNo></deliverNo>");
            xmlBuilder.append("    <type>1</type>");
            xmlBuilder.append("    <totalValue>1</totalValue>");
            xmlBuilder.append("    <itemsWeight>1</itemsWeight>");
            xmlBuilder.append("    <packageOrNot>1</packageOrNot>");
            xmlBuilder.append("    <orderSource>1</orderSource>");
            xmlBuilder.append("    <sender>");
            xmlBuilder.append("        <name>汪明新</name>");
            xmlBuilder.append("        <postCode>123456</postCode>");
            xmlBuilder.append("        <phone>1234567</phone>");
            xmlBuilder.append("        <mobile>18221885929</mobile>");
            xmlBuilder.append("        <prov>上海市</prov>");
            xmlBuilder.append("        <city>上海市,长宁区</city>");
            xmlBuilder.append("        <address>上海市青浦区华徐公路民兴大道</address>");
            xmlBuilder.append("    </sender>");
            xmlBuilder.append("    <receiver>");
            xmlBuilder.append("        <name>汪明新</name>");
            xmlBuilder.append("        <postCode>123456</postCode>");
            xmlBuilder.append("        <phone>1234567</phone>");
            xmlBuilder.append("        <mobile>18221885929</mobile>");
            xmlBuilder.append("        <prov>浙江省</prov>");
            xmlBuilder.append("        <city>金华市</city>");
            xmlBuilder.append("        <address>赤松路308号</address>");
            xmlBuilder.append("    </receiver>");
            xmlBuilder.append("    <items>");
            xmlBuilder.append("        <item>");
            xmlBuilder
                .append("            <itemName>36ab0b08-3b5c-4423-a352-08477f050e55</itemName>");
            xmlBuilder.append("            <number>2</number>");
            xmlBuilder.append("            <itemValue>50</itemValue>");
            xmlBuilder.append("        </item>");
            xmlBuilder.append("        <item>");
            xmlBuilder
                .append("            <itemName>0a4e51b9-5616-4feb-b8a8-d2e1ba24401f</itemName>");
            xmlBuilder.append("            <number>2</number>");
            xmlBuilder.append("            <itemValue>50</itemValue>");
            xmlBuilder.append("        </item>");
            xmlBuilder.append("    </items>");
            xmlBuilder.append("</RequestOrder>");

            // 签名
            String data_digest = new String(Base64.encodeBase64(DigestUtils.md5(xmlBuilder
                .toString() + parternId)));

            //查询
            String queryString = "logistics_interface="
                                 + URLEncoder.encode(xmlBuilder.toString(), "UTF-8")
                                 + "&data_digest=" + URLEncoder.encode(data_digest, "UTF-8")
                                 + "&clientId=" + URLEncoder.encode(clientId, "UTF-8");

            HttpRequest req = new HttpRequest();
            req.setUrl(apiUrl + "?" + queryString).setNeedBody(true);
            HttpResponse resp = new HttpUtil().request(req, null, HttpStatus.SC_OK, true);

            //获取服务端的反馈
            String responseString = resp.getBody();

            log.error("请求的返回信息：" + responseString);

        } catch (Exception e) {
            e.printStackTrace();
        }

        return "123";
    }

    public static void main(String[] args) {
        String a = YtoUtil.getInstance().createOrder(null);
        System.out.println(a);
    }
}