package com.thebeastshop.pegasus.integration.express.sf;

import com.thebeastshop.pegasus.integration.constants.ExpressTypeConstants;
import com.thebeastshop.pegasus.integration.exception.IntegrationException;
import com.thebeastshop.pegasus.integration.exception.IntegrationExceptionErrorCode;
import com.thebeastshop.pegasus.integration.express.PackageInfo;
import com.thebeastshop.pegasus.integration.express.PackageSkuInfo;
import com.thebeastshop.pegasus.integration.express.RouteInfo;
import com.thebeastshop.pegasus.integration.express.sf.ws.CommonExpressServiceService;
import com.thebeastshop.pegasus.integration.express.sf.ws.IExpressService;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.XMLUtil;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Created by roy on 15-12-28.
 */
@Component
public class SFUtil {
    private static final Logger log = LoggerFactory.getLogger(SFUtil.class);


    private final Semaphore semaphore = new Semaphore(2);
    private ReentrantLock reentrantLock = new ReentrantLock();
    private volatile boolean canUse = true;

    private volatile int _MAX_THREAD_SIZE = Runtime.getRuntime().availableProcessors() * 2;

    /**
     * 接入编码
     * checkword
     */
    @Value("${usercode}")
    private  String _SF_EXPRESS_USER_CODE;
    @Value("${checkword}")
    private  String _SF_EXPRESS_PWD;
    /**
     * 顺丰月结帐号
     */
    @Value("${custid}")
    private  String _SF_EXPRESS_CUSTID;
    @Value("${env}")
    private String env;
    /**
     * 1-标准快递，2-顺丰特惠
     */
    private static final String _SF_EXPRESS_TYPE = "2";


    /**
     * 支付方式 1-寄方付，2-收方付，3-第三方付，默认是1
     */
    private static final String _SF_EXPRESS_PAY_TYPE = "1";

    /**
     * reponse head
     */
    private static final String _SF_RESPONSE_SUCC = "OK";
    private static final String _SF_RESPONSE_ERR = "ERR";

    /**
     * _WS_CONNECTION_TIMEOUT :  ms
     * _WS_REQUEST_TIMEOUT : ms
     * timeout = _WS_CONNECTION_TIMEOUT + _WS_REQUEST_TIMEOUT
     */
    private static final int _WS_CONNECTION_TIMEOUT = 3000;
    private static final int _WS_REQUEST_TIMEOUT = 3000;

    /**
     * Blocking timeout : s,
     * waiting timeout : s,
     */
    public static final int _BLOCKING_TIMEOUT = 20;
    public static final int _WAITING_TIMEOUT = 30;


    private static final String _BEAST_OFFICE_ADDRESS = new StringBuilder(100)
            .append(" j_company='野兽派花店'\n")
            .append(" j_contact='LEA' j_tel='021-32580718,021-52991228' j_mobile=''\n")
            .append(" j_province='上海' j_city='上海' j_county='长宁区'\n")
            .append(" j_address='淮海西路'\n")
            .append(" d_company=''\n")
            .toString();

    public String orderZDService (final PackageInfo packageInfo) {
        //check can use befor
        if (!canUse) {
            return null;
        }
        String expressOrderNo = packageInfo.getExpressOrderNo();

        StringBuilder xmlBuilder = new StringBuilder(512);
        String xml = xmlBuilder.append("<Request service='OrderZDService' lang='zh-CN'>\n")
                .append("<Head>").append(_SF_EXPRESS_USER_CODE).append("</Head>\n")
                .append("<Body>\n")
                .append("<OrderZD  orderid ='").append(packageInfo.getExpressOrderNo()).append("'\n")
                .append("parcel_quantity='").append(packageInfo.getOrderNum()).append("'\n")
                .append("/>\n")
                .append("</Body></Request>")
                .toString();
//        System.out.println(_SF_EXPRESS_USER_CODE);

        try {
            String responseXml = getResponseXml(xml);
            System.out.println(Thread.currentThread().getName()+"response ok "+responseXml);
            XPath xpath = XPathFactory.newInstance().newXPath();
//            System.out.println(Thread.currentThread().getName()+"xpath ok ");
            String result = (String) xpath.evaluate("/Response/Head", new InputSource(new ByteArrayInputStream(responseXml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);

//            System.out.println(Thread.currentThread().getName()+"result ok "+result);

//            log.warn("{}", expressOrderNo + "  ::  " + xml);
            if (StringUtils.equals(_SF_RESPONSE_SUCC, result)) {
                String mailNo = XMLUtil.parseString("/Response/Body/OrderZDResponse/OrderZDResponse/@mailno_zd", responseXml);
                packageInfo.setChildrenExpressNo(mailNo);

                return mailNo;
            } else {
//                log.warn("{}", expressOrderNo + "  ::  " + responseXml);
            }
//            log.warn("{}",expressOrderNo + "  ::  " + responseXml);
        } catch (Exception e) {
//            System.out.println(Thread.currentThread().getName() + "-------------------SFUtil.generateExpressNo-----Exception-----------");
//            log.warn("", e);
            setCanUse(true);
        }
        return null;
    }
    /**
     * @param packageInfo //     * @param isgen       true: generate a mailno; false: no mailno
     * @return
     */
    public String generateExpressNo(final PackageInfo packageInfo) {
        //check can use befor
        if (!canUse) {
            return null;
        }
        String is_gen = "is_gen_bill_no='1'";

        String expressNo = null;
        String[] custAddrs = packageInfo.getCustAddr().split("-");
        if (StringUtils.isBlank(packageInfo.getCustAddr())) {
            custAddrs = new String[]{"", "", "", ""};
        }
        StringBuilder epOrderSkus = new StringBuilder();
        for (PackageSkuInfo sku : packageInfo.getSkus()) {
            epOrderSkus.append("<Cargo name='").append(sku.getSkuName()).append(" * ").append(sku.getSkuNum()).append("'").append(" currency='CNY' source_area='中国' ").append("></Cargo>").append("\n");
        }
        if (CollectionUtils.isEmpty(packageInfo.getSkus())) {
            log.warn("{}","sf-生成单号接口-发送cargo为空，packageNo:"+packageInfo.getOrderNo());
        }
        String d_province = custAddrs[1];
        String d_city = custAddrs[2];
        String d_district = custAddrs[3];

        String expressOrderNo = getUniqueOrderNo(packageInfo);
        packageInfo.setExpressOrderNo(expressOrderNo);

        StringBuilder xmlBuilder = new StringBuilder(512);
        String cusId = env.equals("test")?_SF_EXPRESS_CUSTID:packageInfo.getMonthlyAccount();
        String xml = xmlBuilder.append("<Request service='OrderService' lang='zh-CN'>\n")
                .append("<Head>").append(_SF_EXPRESS_USER_CODE).append("</Head>\n")
                .append("<Body>\n")
                .append("<Order orderid ='").append(expressOrderNo).append("'\n")
                //获取快递单号
                .append(is_gen)
                .append(_BEAST_OFFICE_ADDRESS)
                .append("d_contact='").append(packageInfo.getRecName()).append("' d_tel='' d_mobile='").append(packageInfo.getRecPhone()).append("'\n")
                .append("d_province='").append(d_province).append("' d_city='").append(d_city).append("' d_county='").append(d_district).append("'\n")
                .append("d_address='").append(packageInfo.getRecAddress()).append("'\n")
                .append("express_type ='").append(ExpressTypeConstants.getSFExpressType(packageInfo.getExpressType())).append("'\n")
                .append("custid ='").append(cusId).append("' ").append("\n")
                .append("pay_method ='").append(_SF_EXPRESS_PAY_TYPE).append("'").append("\n")
                .append(">\n")
                .append(epOrderSkus.toString())
//                .append(" <AddedService name='托寄物' ></AddedService>")
                .append("</Order>\n</Body></Request>")
                .toString();


//        System.out.println(_SF_EXPRESS_USER_CODE);

        try {
            String responseXml = getResponseXml(xml);
            System.out.println(Thread.currentThread().getName()+"response ok "+responseXml);
            XPath xpath = XPathFactory.newInstance().newXPath();
//            System.out.println(Thread.currentThread().getName()+"xpath ok ");
            String result = (String) xpath.evaluate("/Response/Head", new InputSource(new ByteArrayInputStream(responseXml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);

//            System.out.println(Thread.currentThread().getName()+"result ok "+result);

//            log.warn("{}", expressOrderNo + "  ::  " + xml);
            if (StringUtils.equals(_SF_RESPONSE_SUCC, result)) {
                String mailNo = XMLUtil.parseString("/Response/Body/OrderResponse/@mailno", responseXml);
                String originCode = XMLUtil.parseString("/Response/Body/OrderResponse/@origincode", responseXml);
                String destCode = XMLUtil.parseString("/Response/Body/OrderResponse/@destcode", responseXml);

                packageInfo.setDeliveryCode(mailNo);
                packageInfo.setOriginCode(originCode);
                packageInfo.setDestCode(destCode);

                return mailNo;
            } else {
//                log.warn("{}", expressOrderNo + "  ::  " + responseXml);
            }
//            log.warn("{}",expressOrderNo + "  ::  " + responseXml);
        } catch (Exception e) {
//            System.out.println(Thread.currentThread().getName() + "-------------------SFUtil.generateExpressNo-----Exception-----------");
            log.warn("", e);
            setCanUse(true);
            return expressNo;
        }
        return expressNo;
    }

    /**
     * @param mailNo
     * @param fetch  是否获取所有物流信息
     * @return
     */
    public List<RouteInfo> findRouteInfo(String mailNo, boolean fetch) {
        List<RouteInfo> routers = Collections.EMPTY_LIST;
        StringBuilder xmlBuilder = new StringBuilder(256);
        String xml = xmlBuilder.append("<Request service='RouteService' lang='zh-CN'>\n")
                .append("<Head>").append(_SF_EXPRESS_USER_CODE).append("</Head>\n")
                .append("<Body>\n")
                .append("<RouteRequest ")
                .append(" tracking_type='1'")
                .append(" method_type='1'")
                .append(" tracking_number='").append(mailNo).append("'\n")
                .append("></RouteRequest>\n")
                .append("</Body></Request>").toString();
        String responseXml = getResponseXml(xml);
        try {
            String result = XMLUtil.parseString("/Response/Head", responseXml);

            if (StringUtils.equals(_SF_RESPONSE_SUCC, result)) {
                NodeList routeList = XMLUtil.parseNodeList("/Response/Body/RouteResponse/Route", responseXml);
                if (routeList != null) {
                    routers = new ArrayList<>();
                    for (int i = 0; i < routeList.getLength(); i++) {
                        Node node = routeList.item(i);
                        NamedNodeMap attributes = node.getAttributes();
                        RouteInfo router = new RouteInfo();
                        router.setAcceptAddress(getNodeValue(attributes.getNamedItem("accept_address")));
                        router.setAcceptTime(getNodeValue(attributes.getNamedItem("accept_time")));
                        router.setOpcode(getNodeValue(attributes.getNamedItem("opcode")));
                        router.setRemark(getNodeValue(attributes.getNamedItem("remark")));
                        routers.add(router);
                        //not fetch all route info,just validate is delivery
                        if (!fetch) break;
                    }
                }
            } else {
                return Collections.EMPTY_LIST;
            }

        } catch (XPathExpressionException e) {
//            System.out.println(Thread.currentThread().getName() + "-------------------SFUtil.RouteService-----Exception-----------");
//            log.warn("", e);
            setCanUse(true);
        }
        return routers;
    }

    /**
     * @param expressOrderNo 运单对应的订单编号，就是获取快递单号时的订单编号
     * @return
     */
    @Deprecated
    private String findOrderInfo(String expressOrderNo) {
        if (StringUtils.isBlank(expressOrderNo)) {
            return null;
        }

        StringBuilder xmlBuilder = new StringBuilder(128);
        String xml = xmlBuilder.append("<Request service='OrderSearchService' lang='zh-CN'>\n")
                .append("<Head>BSPdevelop</Head>\n")
                .append("<Body>\n")
                .append("<OrderSearch orderid ='").append(expressOrderNo + "' \n")
                .append("></OrderSearch>\n")
                .append("</Body></Request>").toString();
        try {
            String responseXml = getResponseXml(xml);
            String result = XMLUtil.parseString("/Response/Head", responseXml);
            // responseXml中有区域编码 maybe return search info object (packgeNo,mailno,origincode,destcode)
            if (StringUtils.equals(_SF_RESPONSE_SUCC, result)) {
                return XMLUtil.parseString("/Response/Body/OrderResponse/@mailno", responseXml);
            } else {
//                log.warn("{}", expressOrderNo + "  ::  " + responseXml);
            }
        } catch (Exception e) {
//            System.out.println(Thread.currentThread().getName() + "-------------------SFUtil.findOrderInfo-----Exception-----------expressOrderNo:" + expressOrderNo);
//            log.warn("", e);
            setCanUse(true);
            return null;
        }

        return null;
    }

    public String getNodeValue(Node node) {
        return node == null ? null : node.getNodeValue();
    }


    public Map<String, String> generateExpressNo(List<PackageInfo> packageInfos) {
        if (CollectionUtils.isNotEmpty(packageInfos)) {
            try {
                /**
                 * semaphore: multi
                 */
                semaphore.tryAcquire(_BLOCKING_TIMEOUT, TimeUnit.SECONDS);
            } catch (InterruptedException e) {
//                log.warn("", e);
                throw new IntegrationException(IntegrationExceptionErrorCode.EXPRESS_EXCEPTION, "系统忙，请稍后再试！");
            }

            try {
                ExecutorService executor = Executors.newFixedThreadPool(_MAX_THREAD_SIZE);
                for (PackageInfo packageInfo : packageInfos) {
                    executor.execute(new SFExpressNoTask(packageInfo));
                }
                executor.shutdown();
                executor.awaitTermination(_WAITING_TIMEOUT, TimeUnit.SECONDS);
            } catch (Exception e) {
//                log.warn("", e);
            } finally {
                semaphore.release();
                setCanUse(true);
            }

        } else {
            return Collections.EMPTY_MAP;
        }

        return Collections.EMPTY_MAP;
    }


    private IExpressService createSFService() {
        if (!canUse) return null;
        URL url = null;
        WebServiceException e = null;
        try {
            url = CommonExpressServiceService.class.getClassLoader().getResource("pegasus-integration/wsdl/"+env+"/sfexpress.wsdl");
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        IExpressService service = new CommonExpressServiceService(url).getCommonExpressServicePort();
        ((BindingProvider) service).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", _WS_CONNECTION_TIMEOUT);
        ((BindingProvider) service).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", _WS_REQUEST_TIMEOUT);
        return service;
    }

    private String getUniqueOrderNo(PackageInfo packageInfo) {
        StringBuilder orderNo = new StringBuilder(64);
        orderNo.append(packageInfo.getOrderNo());
        orderNo.append(DateUtil.format(DateUtil.getNow(), "yyyyMMddHHmmss"));
        return orderNo.toString();
    }

    private String getResponseXml(String xml) {
        return createSFService().sfexpressService(xml, Base64.encodeBase64String(DigestUtils.md5(xml + _SF_EXPRESS_PWD)));
    }

    public boolean isCanUse() {
        return canUse;
    }

    public void setCanUse(boolean canUse) {
        this.canUse = canUse;
    }

    class SFExpressNoTask implements Runnable {
        private PackageInfo packageInfo;

        public SFExpressNoTask(PackageInfo packageInfo) {
            this.packageInfo = packageInfo;
        }

        @Override
        public void run() {
            generateExpressNo(packageInfo);
        }
    }

}
