package com.thebeastshop.pegasus.integration.express.fed.common;

import com.thebeastshop.pegasus.integration.express.fed.FedUtil;
import com.thebeastshop.pegasus.util.comm.DSAUtil;
import com.thebeastshop.pegasus.util.comm.SHA256Util;
import org.springframework.core.io.ClassPathResource;

/**
 * 验证服务端返回的报文是否正确
 * @author devin.li on 2016/2/19.
 *
 */
public class Validation {
    private static final String PATH = FedUtil.PROD_PATH + "FexPublic.pem";
    public static boolean getValidation(String xmlToString){
        try {
            String mac = xmlToString.substring(xmlToString.indexOf("<MAC>")+5, xmlToString.lastIndexOf("</MAC>"));
            System.out.println("MAC: ------- " + mac);

            //报文验证
            String strFormMessageContent = xmlToString.substring(xmlToString.indexOf("<MessageContent>"), xmlToString.lastIndexOf("</ResponseMessage>"));

            System.out.println("strFormMessageContent: ------- " + strFormMessageContent);

            //TODO   根据companyCode 取 对应的公钥文件名
            String publicKey = DSAUtil.initPublicKey(PATH); //Prod environment
            String str256 = SHA256Util.encrypt(strFormMessageContent);
            // 验证签名
            return DSAUtil.verify(str256.getBytes(), publicKey, mac);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

