/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration.express;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Royan
 * @version $Id: PackageInfo.java, v 0.1 2015-11-02 下午5:42
 */
public class PackageInfo {

    /**
     * 快递单号
     */
    private String deliveryCode;
    /**
     * 获取快递单号时的  订单编码
     * OpSoPackageDeliveryInfo.ext1
     *
     */
    private String expressOrderNo;

    /**
     * 区域编码
     * originCode： 寄件区域   OpSoPackageDeliveryInfo.ext2
     * destCode： 收件区域     OpSoPackageDeliveryInfo.ext3
     */
    private String originCode;
    private String destCode;


    /**
     * 包裹单号
     */
    private String orderNo;
    /**
     * 订单人，姓名，联系方式，邮箱，客户分组(普通、vip、vvip)
     */
    private String custName;
    private String custPhone;
    private String custEmail;
    private String custGroup;

    /**
     * 订单信息
     * 是否匿名，是/否
     */
    private String isAnony;
    /**
     * 是否有卡片、留言，要/不要
     */
    private String isCateNote;
    /**
     * 订单总件数 int
     */
    private int orderNum;
    private String monthlyAccount;
    /**
     * 订单总金额，%.2f
     */
    private Double orderSum;
    /**
     * 实际支付金额
     */
    private Double paySum;
    /**
     * 限时送达
     */
    private String limitDelivery;

    /**
     * 制单时间
     */
    private String orderMakeTime;

    /**
     * 收货信息
     * 姓名，联系方式，地址
     */
    private String recName;
    private String recPhone;
    private String recAddress;

    /**
     * 卡片内容
     */
    private String cardNote;
    /**
     * 备注
     */
    private String remark;
    /**
     * 商品列表
     */
    List<PackageSkuInfo> skus = new ArrayList<>();

    /**
     * 收货地址 格式如下
     * "正灵芝  女士  13818798733，上海市 上海市 浦东新区 浦东新区海阳路1179 1189号综合部 [200136]"
     * 上海市 上海市 浦东新区
     */
    private String custProvince;
    private String custCity;
    private String custDistrict;

    private String custAddr ;
    private String custTitle;
    private String zipCode;
    /**
     * 预计发货日期
     */
    private Date planedDeliveryDate;
    /**
     * 发货日期
     */
    private Date deliveryDate;
    /**
     * 快递类型
     */
    private Integer expressType;
    /**
     * 包裹主键
     */
    private Long packageId;

    /**
     * 收件人邮编
     */
    private String recPostalCode;

    /**
     * 快递单下载url
     */
    private String expressImgURL;

    /**
     * 快递单本地路径
     * @return
     */
    private String expressImgPath;

    //仓库地址
    private String warehouseAddress;

    private String warehouseProvince;

    private String warehouseCity;

    //仓库邮编
    private String warehousePostCode;
    //仓库地区
    private String warehouseDistrict;
    //子快递单号
    private String childrenExpressNo;

    private String channelCode;


    //tms 信息
    private String orderCode;

    private Long physicalWarehouseId;

    private Long districtId;

    private String address;

    //private String zipCode;

    private String circuitDesc;

    private String companyName;

    private String title;

    private String receiver;

    private String receiverPhone;

    private Date expectReceiveDate;

    //private Date planedDeliveryDate;

    private Date deliveryTime;

    private Date createTime;

    private Integer parcelquantity;

    private String servicePhone;

    private String mark;
    //tms 信息
    public String getOrderNo() {
        return orderNo;
    }

    public String getExpressOrderNo() {
        return expressOrderNo;
    }

    public String getOriginCode() {
        return originCode;
    }

    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    public String getDestCode() {
        return destCode;
    }

    public void setDestCode(String destCode) {
        this.destCode = destCode;
    }

    public void setExpressOrderNo(String expressOrderNo) {
        this.expressOrderNo = expressOrderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCustName() {
        return custName;
    }

    public String getChildrenExpressNo() {
        return childrenExpressNo;
    }


    public void setChildrenExpressNo(String childrenExpressNo) {
        this.childrenExpressNo = childrenExpressNo;
    }

    public void setCustName(String custName) {
        this.custName = custName;
    }

    public String getMonthlyAccount() {
        return monthlyAccount;
    }

    public void setMonthlyAccount(String monthlyAccount) {
        this.monthlyAccount = monthlyAccount;
    }

    public String getCustPhone() {
        return custPhone;
    }

    public void setCustPhone(String custPhone) {
        this.custPhone = custPhone;
    }

    public String getCustEmail() {
        return custEmail;
    }

    public void setCustEmail(String custEmail) {
        this.custEmail = custEmail;
    }

    public String getCustGroup() {
        return custGroup;
    }

    public void setCustGroup(String custGroup) {
        this.custGroup = custGroup;
    }

    public String getIsAnony() {
        return isAnony;
    }

    public void setIsAnony(String isAnony) {
        this.isAnony = isAnony;
    }

    public String getIsCateNote() {
        return isCateNote;
    }

    public void setIsCateNote(String isCateNote) {
        this.isCateNote = isCateNote;
    }

    public int getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public Double getOrderSum() {
        return orderSum;
    }

    public void setOrderSum(Double orderSum) {
        this.orderSum = orderSum;
    }

    public Double getPaySum() {
        return paySum;
    }

    public void setPaySum(Double paySum) {
        this.paySum = paySum;
    }

    public String getLimitDelivery() {
        return limitDelivery;
    }

    public void setLimitDelivery(String limitDelivery) {
        this.limitDelivery = limitDelivery;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getOrderMakeTime() {
        return orderMakeTime;
    }

    public void setOrderMakeTime(String orderMakeTime) {
        this.orderMakeTime = orderMakeTime;
    }

    public String getRecName() {
        return recName;
    }

    public void setRecName(String recName) {
        this.recName = recName;
    }

    public String getRecPhone() {
        return recPhone;
    }

    public void setRecPhone(String recPhone) {
        this.recPhone = recPhone;
    }

    public String getRecAddress() {
        return recAddress;
    }

    public void setRecAddress(String recAddress) {
        this.recAddress = recAddress;
    }

    public String getCardNote() {
        return cardNote;
    }

    public void setCardNote(String cardNote) {
        this.cardNote = cardNote;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<PackageSkuInfo> getSkus() {
        return skus;
    }

    public void setSkus(List<PackageSkuInfo> skus) {
        this.skus = skus;
    }

    public String getCustAddr() {
        return custAddr;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setCustAddr(String custAddr) {
        this.custAddr = custAddr;
    }

    public String getCustTitle() {
        return custTitle;
    }

    public void setCustTitle(String custTitle) {
        this.custTitle = custTitle;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public Date getPlanedDeliveryDate() {
        return planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(Integer expressType) {
        this.expressType = expressType;
    }

    public String getDeliveryCode() {
        return deliveryCode;
    }

    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    public Long getPackageId() {
        return packageId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public String getRecPostalCode() {
        return recPostalCode;
    }

    public void setRecPostalCode(String recPostalCode) {
        this.recPostalCode = recPostalCode;
    }

    public String getExpressImgURL() {
        return expressImgURL;
    }

    public void setExpressImgURL(String expressImgURL) {
        this.expressImgURL = expressImgURL;
    }

    public String getExpressImgPath() {
        return expressImgPath;
    }

    public void setExpressImgPath(String expressImgPath) {
        this.expressImgPath = expressImgPath;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getPhysicalWarehouseId() {
        return physicalWarehouseId;
    }

    public void setPhysicalWarehouseId(Long physicalWarehouseId) {
        this.physicalWarehouseId = physicalWarehouseId;
    }

    public Long getDistrictId() {
        return districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCircuitDesc() {
        return circuitDesc;
    }

    public void setCircuitDesc(String circuitDesc) {
        this.circuitDesc = circuitDesc;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getReceiverPhone() {
        return receiverPhone;
    }

    public void setReceiverPhone(String receiverPhone) {
        this.receiverPhone = receiverPhone;
    }

    public Date getExpectReceiveDate() {
        return expectReceiveDate;
    }

    public void setExpectReceiveDate(Date expectReceiveDate) {
        this.expectReceiveDate = expectReceiveDate;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getParcelquantity() {
        return parcelquantity;
    }

    public void setParcelquantity(Integer parcelquantity) {
        this.parcelquantity = parcelquantity;
    }

    public String getMark() {
        return mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public String getWarehousePostCode() {
        return warehousePostCode;
    }

    public void setWarehousePostCode(String warehousePostCode) {
        this.warehousePostCode = warehousePostCode;
    }

    public String getCustProvince() {
        return custProvince;
    }

    public void setCustProvince(String custProvince) {
        this.custProvince = custProvince;
    }

    public String getCustCity() {
        return custCity;
    }

    public void setCustCity(String custCity) {
        this.custCity = custCity;
    }

    public String getCustDistrict() {
        return custDistrict;
    }

    public void setCustDistrict(String custDistrict) {
        this.custDistrict = custDistrict;
    }

    public String getWarehouseDistrict() {
        return warehouseDistrict;
    }

    public void setWarehouseDistrict(String warehouseDistrict) {
        this.warehouseDistrict = warehouseDistrict;
    }

    public String getWarehouseProvince() {
        return warehouseProvince;
    }

    public void setWarehouseProvince(String warehouseProvince) {
        this.warehouseProvince = warehouseProvince;
    }

    public String getWarehouseCity() {
        return warehouseCity;
    }

    public void setWarehouseCity(String warehouseCity) {
        this.warehouseCity = warehouseCity;
    }

    public String getWarehouseAddress() {
        return warehouseAddress;
    }

    public void setWarehouseAddress(String warehouseAddress) {
        this.warehouseAddress = warehouseAddress;
    }
}