package com.thebeastshop.pegasus.integration.express;

import com.thebeastshop.pegasus.integration.PegasusIntegrationFacade;
import com.thebeastshop.pegasus.integration.express.fed.FedUtil;
import com.thebeastshop.pegasus.integration.express.sf.SFUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * Created by roy on 16-1-4.
 */
public class ExpressUtil {

    /**
     *  顺丰
     * 生成 快递单号
     * 调用完成后会更新 PackageInfo（deliveryCode,originCode,destCode,expressOrderNo)
     * @param packageInfo
     */
    public static void genSFDeliveryCode(PackageInfo packageInfo) {
        PegasusIntegrationFacade.getInstance().getSFUtilBean().generateExpressNo(packageInfo);
    }

    /**
     *  顺丰
     * 批量 生成 快递单号
     * 调用完成后会更新 PackageInfo（deliveryCode,originCode,destCode,expressOrderNo)
     * @param packageInfos
     */
    public static void genSFDeliveryCode(List<PackageInfo> packageInfos) {
        PegasusIntegrationFacade.getInstance().getSFUtilBean().generateExpressNo(packageInfos);
    }

    /**
     *  顺丰  是否有路由信息
     *  根据 快递单号  判断是否有route信息
     *  如果查到 就说明已经发货
     * @param deliveryCode  快递单号
     * @return
     */
    public static boolean validateBySFDeliveryCode(String deliveryCode) {
        if (CollectionUtils.isEmpty(PegasusIntegrationFacade.getInstance().getSFUtilBean().findRouteInfo(deliveryCode, false))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     *  查询顺丰快递路由信息
     * @param deliveryCode  顺丰快递单号
     * @return
     */
    public static List<RouteInfo> findSFRouteInfo(String deliveryCode) {
        return PegasusIntegrationFacade.getInstance().getSFUtilBean().findRouteInfo(deliveryCode, true);
    }

    //devin.li
    /**
     * 联邦 单个
     * 请求快递号
     * @param packageInfo
     * @param needImg 是否获取快递单下载路径
     * 调用完成后会更新 PackageInfo（expressOrderNo,deliveryCode,expressImgURL)
     */
    public static void orderFedExpressInfo(PackageInfo packageInfo,Boolean needImg) {
        FedUtil.getInstance().orderFedExpressInfo(packageInfo, needImg);
    }

    /**
     * 联邦 批量
     * 请求快递号
     * @param packageInfos
     * @param needImg 是否获取快递单下载路径
     */
    public static void orderFedExpressInfo(List<PackageInfo> packageInfos, Boolean needImg) {
        FedUtil.getInstance().orderFedExpressInfo(packageInfos, needImg);
    }

    /**
     * 联邦 单个
     * 获取面单下载url
     * @param orderCode
     * @param expressCode
     */
    public static String getFedExpressImgURL(String orderCode,String expressCode){
       return FedUtil.getInstance().getFedExpressImgURL(orderCode, expressCode);
    }

    /**
     * 联邦 批量
     * 获取面单下载url
     * @return
     */
    public static void getFedExpressImgURL(List<PackageInfo> packageInfos){ FedUtil.getInstance().getFedExpressImgURL(packageInfos); }


    /**
     * 联邦 单个
     * 下载快递面单
     * @param url
     * @param path
     * @return
     */
    public static String getFedExpressImgPath(String url,String path){
       return  FedUtil.getInstance().getFedExpressImgPath(url,path);
    }

    /**
     * 联邦 单个
     * 下载快递面单
     * @param orderCode
     * @param deliveryCode
     * @param path
     * @return
     */
    public static String getFedExpressImgPath(String orderCode,String deliveryCode,String path){
        String url = getFedExpressImgURL(orderCode,deliveryCode);
        if (EmptyUtil.isEmpty(url)) return null;
        return  getFedExpressImgPath(url,path);
    }

    /**
     * 获取联邦包裹状态
     * @param orderCode
     * @param expressCode
     * @return “未接单”，“已接单”和“已取件”
     */
    public static String checkFedStatus(String orderCode,String expressCode){
        return FedUtil.getInstance().checkFedStatus(orderCode,expressCode);
    }

}
