package com.thebeastshop.pegasus.integration.constants;

/**
 * Created by roy on 16-1-4.
 */
public class ExpressTypeConstants {
    // SCM 快递类型 1店送2联邦3顺丰空运4顺丰陆运5圆通6德邦
    public static final Integer EXPRESS_TYPE_SHOP = 1;
    public static final Integer EXPRESS_TYPE_FEDEX = 2;
    public static final Integer EXPRESS_TYPE_SF_AIR = 3;
    public static final Integer EXPRESS_TYPE_SF_LAND = 4;
    public static final Integer EXPRESS_TYPE_YTO = 5;
    public static final Integer EXPRESS_TYPE_DEPPON = 6;

    //SF express type
    public static final Integer SF_EXPRESS_TYPE_AIR = 1;
    public static final Integer SF_EXPRESS_TYPE_LAND = 2;

    /**
     * default is air
     * @param sftype
     * @return
     */
    public static Integer getSFExpressType(Integer sftype) {
        if (EXPRESS_TYPE_SF_AIR.equals(sftype)) {
            return SF_EXPRESS_TYPE_AIR;
        } else if (EXPRESS_TYPE_SF_LAND.equals(sftype)) {
            return SF_EXPRESS_TYPE_LAND;
        }
        return SF_EXPRESS_TYPE_AIR;
    }
}
