/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.integration;

import com.thebeastshop.pegasus.integration.express.sf.SFUtil;
import com.thebeastshop.pegasus.integration.oss.OssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * @author Royan
 * @version $Id: PegasusUtilFacade.java, v 0.1 2015-07-01 下午3:00
 */
public class PegasusIntegrationFacade {

    private final static Logger log = LoggerFactory.getLogger(PegasusIntegrationFacade.class);

    private static PegasusIntegrationFacade instance;

    private static OssUtil ossUtil;
    private static SFUtil sFUtil;
    private PegasusIntegrationFacade() {

    }

    public static PegasusIntegrationFacade getInstance() {
        if (instance != null) {
            return instance;
        }

        synchronized (PegasusIntegrationFacade.class) {
            if (instance == null) {
                log.info("[fasade init start] PegasusUtilFacade");
                new ClassPathXmlApplicationContext("pegasus-integration/spring.xml");
                log.info("[fasade init finish] PegasusUtilFacade");
            }
            instance = (PegasusIntegrationFacade) SpringUtil.getBean("pegasusIntegrationFacade");
            ossUtil = (OssUtil)SpringUtil.getBean("ossUtil");
            sFUtil = (SFUtil)SpringUtil.getBean("sFUtil");
        }
        return instance;
    }
    public OssUtil getOssUtilBean(){
        return ossUtil;
    }
    public SFUtil getSFUtilBean(){
        return sFUtil;
    }
}