/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.support.service.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.support.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

@Component
public class RedisServiceImpl
implements RedisService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(String key, Integer seconds) {
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            jedis.expire(key, seconds.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        String str = "";
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                str = jedis.get(key);
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(String key, Type clazz) {
        Object t = null;
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                String value = jedis.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    T t2 = null;
                    return t2;
                }
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
                t = mapper.readValue(value, mapper.getTypeFactory().constructType(clazz));
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                jedis.set(key, value);
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
    }

    @Override
    public <T> void set(String key, T value) {
        try {
            if (value == null) {
                this.set(key, "");
                return;
            }
            this.set(key, JsonUtil.toJson(value));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int seconds) {
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                jedis.set(key, value);
                jedis.expire(key, seconds);
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
    }

    @Override
    public <T> void set(String key, T value, int seconds) {
        try {
            this.set(key, JsonUtil.toJson(value), seconds);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String key) {
        boolean flag = false;
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                flag = jedis.exists(key);
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(String key) {
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                jedis.del(key);
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        Jedis jedis = null;
        try {
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                Long l = jedis.incr(key);
                return l;
            }
            this.logger.error("redis key cannot be null or blank");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delsBykeyPattern(String keyPattern) {
        try (Jedis jedis = null;){
            if (StringUtils.isNotBlank((String)keyPattern)) {
                jedis = this.pool.getResource();
                Set keys = jedis.keys(keyPattern);
                if (CollectionUtils.isNotEmpty((Collection)keys)) {
                    String[] delKeys = keys.toArray(new String[keys.size()]);
                    jedis.del(delKeys);
                }
            } else {
                this.logger.error("redis key cannot be blank");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(String key) {
        Jedis js = null;
        try {
            if (StringUtils.isNotBlank((String)key)) {
                js = this.pool.getResource();
                Long l = js.decr(key);
                return l;
            }
            this.logger.error("Redis key cannot be null or empty");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != js) {
                js.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(String key, String ... values) {
        Jedis jedis = null;
        try {
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                Long l = jedis.lpush(key, values);
                return l;
            }
            this.logger.error("Redis key cannot be null or empty");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lrange(String key) {
        Jedis jedis = null;
        try {
            if (StringUtils.isNotBlank((String)key)) {
                jedis = this.pool.getResource();
                List list = jedis.lrange(key, 0L, -1L);
                return list;
            }
            this.logger.error("Redis key cannot be null or empty");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hmset(String key, Map<String, String> hash, int second) {
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            Pipeline pipelined = jedis.pipelined();
            pipelined.hmset(key, hash);
            pipelined.expire(key, second);
            pipelined.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... fields) {
        try (Jedis jedis = null;){
            List resultList;
            jedis = this.pool.getResource();
            List list = resultList = jedis.hmget(key, fields);
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getAll(String key) {
        HashMap<String, String> strs = new HashMap<String, String>();
        try (Jedis jedis = null;){
            jedis = this.pool.getResource();
            Set s = jedis.keys(key + "*");
            for (String k : s) {
                String v = jedis.get(k);
                strs.put(k, v);
            }
        }
        return strs;
    }
}

