/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.ElementPool;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PutTogetherUtil {
    private ElementPool pool;
    private Map<Integer, RedElement> eleMap = new HashMap<Integer, RedElement>();
    private List<Integer> priceArray = Lists.newArrayList();
    private Map<Integer, Map<Integer, Integer>> matchTable = new HashMap<Integer, Map<Integer, Integer>>();
    private int maxDisparity;
    private Integer maxPrice;
    private Integer minPrice;
    private Integer averagePrice;

    public void init(ElementPool elementPool) {
        if (null != elementPool) {
            if (null == this.pool) {
                this.pool = elementPool;
            }
            for (RedElement ele : this.pool.getEles()) {
                this.eleMap.put(ele.getValue(), ele);
                this.priceArray.add(ele.getValue());
            }
            this.getMatchTable();
            this.getMaxDisparity();
        }
    }

    private void getMatchTable() {
        this.matchTable.clear();
        for (Integer i : this.priceArray) {
            for (int j = 1; j < this.priceArray.size(); ++j) {
                Integer a = i - this.priceArray.get(j);
                Map<Object, Object> map = null;
                if (this.matchTable.containsKey(a)) {
                    map = this.matchTable.get(a);
                    map.put(i, this.priceArray.get(j));
                    continue;
                }
                map = new HashMap<Integer, Integer>();
                map.put(i, this.priceArray.get(j));
                this.matchTable.put(a, map);
            }
        }
    }

    private void getMaxDisparity() {
        this.maxDisparity = this.priceArray.get(0) - this.priceArray.get(this.priceArray.size() - 1);
    }

    public ElementPool putTogether(ElementPool elementPool, Integer totalPrice) {
        int randomNum;
        if (null == this.pool) {
            this.init(elementPool);
        }
        int average = totalPrice / elementPool.getTotalCount();
        ArrayList gtAverage = Lists.newArrayList();
        ArrayList ltAverage = Lists.newArrayList();
        for (Integer price : this.priceArray) {
            if (price > average) {
                gtAverage.add(price);
                continue;
            }
            ltAverage.add(price);
        }
        int gtRandomNum = randomNum = elementPool.getTotalCount() / 2;
        int ltRandomNum = randomNum;
        if (randomNum * 2 != elementPool.getTotalCount()) {
            ++ltRandomNum;
        }
        List<Object> gtList = Lists.newArrayList();
        List<Object> ltList = Lists.newArrayList();
        Boolean flag = true;
        do {
            int n;
            gtList = this.getRandomList(gtAverage, gtRandomNum);
            ltList = this.getRandomList(ltAverage, ltRandomNum);
            int cutSum = this.getSum((List<Integer>)gtList) + this.getSum((List<Integer>)ltList);
            Iterator<Object> dValue = cutSum - totalPrice;
            if (cutSum > totalPrice) {
                --gtRandomNum;
                ++ltRandomNum;
            } else if (cutSum < totalPrice) {
                ++gtRandomNum;
                --ltRandomNum;
            } else {
                flag = true;
            }
            if (!flag.booleanValue() || !this.matchTable.containsKey(dValue)) continue;
            Map<Integer, Integer> m = this.matchTable.get(dValue);
            for (n = 0; n < gtList.size(); ++n) {
                if (!m.containsKey(gtList.get(n))) continue;
                gtList.set(n, m.get(gtList.get(n)));
                flag = false;
                break;
            }
            for (n = 0; n < ltList.size(); ++n) {
                if (!m.containsKey(ltList.get(n))) continue;
                ltList.set(n, m.get(ltList.get(n)));
                flag = false;
                break;
            }
            if ((cutSum = this.getSum(gtList) + this.getSum(ltList)) == totalPrice) continue;
            flag = true;
        } while (flag.booleanValue());
        HashMap<Object, Integer> eleNumMap = new HashMap<Object, Integer>();
        for (Object i : gtList) {
            if (eleNumMap.containsKey(i)) {
                eleNumMap.put(i, (Integer)eleNumMap.get(i) + 1);
                continue;
            }
            eleNumMap.put(i, 1);
        }
        for (Object i : ltList) {
            if (eleNumMap.containsKey(i)) {
                eleNumMap.put(i, (Integer)eleNumMap.get(i) + 1);
                continue;
            }
            eleNumMap.put(i, 1);
        }
        ArrayList redEles = Lists.newArrayList();
        for (Map.Entry entry : eleNumMap.entrySet()) {
            RedElement redElement = this.eleMap.get(entry.getKey());
            redElement.setNum((Integer)entry.getValue());
            redEles.add(new RedElement(redElement));
        }
        ElementPool result = new ElementPool(this.pool);
        result.setEles(redEles);
        return result;
    }

    private Integer getSum(List<Integer> list) {
        Integer sum = 0;
        for (Integer i : list) {
            sum = sum + i;
        }
        return sum;
    }

    private List<Integer> getRandomList(List<Integer> sources, Integer count) {
        ArrayList<Integer> targets = new ArrayList<Integer>();
        int i = sources.size();
        for (int j = 0; j < count; ++j) {
            int idx = new Random().nextInt(i);
            targets.add(sources.get(idx));
        }
        return targets;
    }
}

