/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopeMapper;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RedEnvelopeServiceImpl
implements RedEnvelopeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopeMapper mapper;
    @Autowired
    private RedisService redisService;
    private String RED_ENVELOPE_ACTIVITY_KEY = "RE_ACTIVITY_";

    @Override
    @Transactional
    public boolean updateStock(Long id) {
        this.logger.info("\u66f4\u65b0\u5206\u4eab\u6d3b\u52a8id[{}]\u7684\u7ea2\u5305\u5e93\u5b58", (Object)id);
        RedEnvelope old = this.mapper.selectByPrimaryKey(id);
        if (old != null && old.getReleasedCount() < old.getReAmount()) {
            this.logger.info("id[{}]\u5e93\u5b58\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)old));
            RedEnvelope upd = new RedEnvelope();
            upd.setReleasedCount(old.getReleasedCount() + 1);
            upd.setModifyTime(new Date());
            RedEnvelopeExample redEnvelopeExample = new RedEnvelopeExample();
            redEnvelopeExample.createCriteria().andIdEqualTo(id).andReleasedCountLessThan(old.getReAmount());
            int num = this.mapper.updateByExampleSelective(upd, redEnvelopeExample);
            this.logger.info("\u66f4\u65b0id[{}]\u7684\u7ea2\u5305\u5e93\u5b58\uff0c\u7ed3\u679c\uff1a", (Object)(num == 1 ? 1 : 0));
            if (num == 1) {
                return true;
            }
        } else {
            this.logger.warn("id[{}]\u5e93\u5b58\u8bb0\u5f55\u4e3a\u7a7a", (Object)id);
        }
        return false;
    }

    @Override
    public RedEnvelopeDTO getRedEnveloper(Long id) {
        this.logger.info("\u83b7\u53d6id[{}]\u7684\u6d3b\u52a8\u8be6\u60c5", (Object)id);
        RedEnvelopeDTO result = null;
        if (result == null) {
            RedEnvelope old = this.mapper.selectByPrimaryKey(id);
            result = (RedEnvelopeDTO)BeanUtil.buildFrom((Object)old, RedEnvelopeDTO.class);
        }
        this.logger.info("id[{}]\u7684\u6d3b\u52a8\u8bb0\u5f55\u4fe1\u606f\uff1a{}", (Object)id, (Object)JSON.toJSONString(result));
        return result;
    }

    private String getRedEnveloperRedisKey(String shareId) {
        return this.RED_ENVELOPE_ACTIVITY_KEY + shareId;
    }

    @Override
    public RedEnvelopeDTO getRedEnvelopeByOrder(String orderId, String memberCode) {
        this.logger.info(" \u6839\u636e\u8ba2\u5355\u53f7orderId[{}]\u67e5\u8be2\u7ea2\u5305\u8bb0\u5f55", (Object)orderId);
        RedEnvelopeDTO result = new RedEnvelopeDTO();
        RedEnvelopeExample example = new RedEnvelopeExample();
        example.createCriteria().andBindIdEqualTo(orderId).andMemberCodeEqualTo(memberCode);
        List<RedEnvelope> reds = this.mapper.selectByExample(example);
        result = null != reds && reds.size() > 0 ? (RedEnvelopeDTO)BeanUtil.buildFrom((Object)reds.get(0), RedEnvelopeDTO.class) : null;
        return result;
    }

    @Override
    public int newRedEnvelopeByOrder(RedEnvelope record) {
        return this.mapper.insert(record);
    }
}

