/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopeRecordMapper;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeRecordDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeRecord;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeRecordExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeRecordService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedEnvelopeRecordServiceImpl
implements RedEnvelopeRecordService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopeRecordMapper mapper;
    @Autowired
    private RedisService redisService;
    private String RED_ENVELOPE_RECORDS_KEY = "RE_RECORDS_";

    @Override
    public RedEnvelopeRecordDTO saveRedEnveloperRecord(RedEnvelopeRecordDTO redEnvelopeRecordDTO) {
        RedEnvelopeRecordDTO result = null;
        if (redEnvelopeRecordDTO == null) {
            this.logger.warn("\u4fdd\u5b58\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55\u5165\u53c2\uff1a\u4e3a\u7a7a");
        } else {
            this.logger.warn("\u4fdd\u5b58\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)redEnvelopeRecordDTO));
            RedEnvelopeRecord record = (RedEnvelopeRecord)BeanUtil.buildFrom((Object)redEnvelopeRecordDTO, RedEnvelopeRecord.class);
            record.setCreateTime(new Date());
            this.mapper.insert(record);
            result = (RedEnvelopeRecordDTO)BeanUtil.buildFrom((Object)record, RedEnvelopeRecordDTO.class);
        }
        this.logger.info("\u4fdd\u5b58\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString(result));
        return result;
    }

    @Override
    public List<RedEnvelopeRecordDTO> queryRecordByActivityId(String shareActivityId) {
        this.logger.info("\u6839\u636e\u5206\u4eab\u6d3b\u52a8[{}]\u67e5\u8be2\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55", (Object)shareActivityId);
        RedEnvelopeRecordExample example = new RedEnvelopeRecordExample();
        example.createCriteria().andShareActivityIdEqualTo(shareActivityId);
        List<RedEnvelopeRecord> list = this.mapper.selectByExample(example);
        List result = BeanUtil.buildListFrom(list, RedEnvelopeRecordDTO.class);
        this.logger.info("\u5206\u4eab\u6d3b\u52a8[{}]\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55\uff1a{}", (Object)shareActivityId, (Object)JSON.toJSONString((Object)result));
        return result;
    }

    private String getRedEnveloperRedisKey(String shareId) {
        return this.RED_ENVELOPE_RECORDS_KEY + shareId;
    }
}

