/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopePrizeGroupMapper;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroup;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroupExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopePrizeGroupService;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedEnvelopePrizeGroupServiceImpl
implements RedEnvelopePrizeGroupService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopePrizeGroupMapper mapper;

    @Override
    public Boolean addRedEnvelopePrizeGroup(List<RedEnvelopePrizeGroup> prizeGroups) {
        if (CollectionUtils.isNotEmpty(prizeGroups)) {
            for (RedEnvelopePrizeGroup prize : prizeGroups) {
                this.mapper.insert(prize);
            }
        }
        return null;
    }

    @Override
    public Boolean updateStock(Long id) {
        this.logger.info("\u66f4\u65b0\u5206\u4eab\u6d3b\u52a8id[{}]\u7684\u7ea2\u5305\u5e93\u5b58", (Object)id);
        RedEnvelopePrizeGroup old = this.mapper.selectByPrimaryKey(id);
        if (old != null && old.getReleasedCount() < old.getReAmount()) {
            this.logger.info("id[{}]\u5e93\u5b58\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)old));
            RedEnvelopePrizeGroup upd = new RedEnvelopePrizeGroup();
            upd.setReleasedCount(old.getReleasedCount() + 1);
            upd.setModifyTime(new Date());
            RedEnvelopePrizeGroupExample redEnvelopeExample = new RedEnvelopePrizeGroupExample();
            redEnvelopeExample.createCriteria().andIdEqualTo(id).andReleasedCountLessThan(old.getReAmount());
            int num = this.mapper.updateByExampleSelective(upd, redEnvelopeExample);
            this.logger.info("\u66f4\u65b0id[{}]\u7684\u7ea2\u5305\u5e93\u5b58\uff0c\u7ed3\u679c\uff1a", (Object)(num == 1 ? 1 : 0));
            if (num == 1) {
                return true;
            }
        } else {
            this.logger.warn("id[{}]\u5e93\u5b58\u8bb0\u5f55\u4e3a\u7a7a", (Object)id);
        }
        return false;
    }

    @Override
    public List<RedEnvelopePrizeGroup> getPrizeGroupByActiveId(Long activityId) {
        this.logger.info("\u83b7\u53d6\u5206\u4eab\u6d3b\u52a8id[{}]\u7684\u7ea2\u5305\u5956\u54c1\u7ec4\u5408", (Object)activityId);
        RedEnvelopePrizeGroupExample example = new RedEnvelopePrizeGroupExample();
        example.createCriteria().andActivityIdEqualTo(activityId);
        List<RedEnvelopePrizeGroup> prizeGroups = this.mapper.selectByExample(example);
        return prizeGroups;
    }
}

