/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.product.warehouse.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.product.warehouse.service.ProductWarehouseService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleSaleInvVO;
import com.thebeastshop.pegasus.service.purchase.PegasusPurchaseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.pegasus.service.warehouse.vo.WhRecipeInvVO;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductWarehouseServiceImpl
implements ProductWarehouseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PegasusWarehouseServiceFacade warehouseService = PegasusWarehouseServiceFacade.getInstance();
    private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();
    private PegasusPurchaseServiceFacade phInstance = PegasusPurchaseServiceFacade.getInstance();
    @Autowired
    private McPsSkuService mcPsSkuService;
    @Autowired
    private SStockService sStockService;

    private boolean checkIsJIT(PsSkuVO sku) {
        boolean flag = false;
        if (sku != null && sku.getIsJit().equals(1)) {
            flag = true;
        }
        return flag;
    }

    private Map<PsSkuVO, Integer> mapJITSkuStock(List<PsSkuVO> skus, boolean isCombined, String warehouseCode) {
        if (!isCombined) {
            ArrayList skuCodes = Lists.newArrayList();
            HashMap rt = Maps.newHashMap();
            HashMap rtn = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(skus)) {
                for (PsSkuVO sku : skus) {
                    if (sku == null || !this.checkIsJIT(sku)) continue;
                    rt.put(sku, Integer.MAX_VALUE);
                    if (sku.getCanCustomize() == null || sku.getCanCustomize() != 1) continue;
                    skuCodes.add(sku.getSkuCode());
                }
            }
            if (skuCodes.size() > 0 && rt.size() > 0) {
                Map whReipeInvVOMaps = this.phInstance.caculateRecipeAmountForAssemble((List)skuCodes, warehouseCode);
                for (PsSkuVO psSku : rt.keySet()) {
                    WhRecipeInvVO whRecipeInvVO = (WhRecipeInvVO)whReipeInvVOMaps.get(psSku.getSkuCode());
                    if (whRecipeInvVO != null && whRecipeInvVO.isRecipeExist()) {
                        rtn.put(psSku, whRecipeInvVO.getCanUseInv());
                        continue;
                    }
                    rtn.put(psSku, Integer.MAX_VALUE);
                }
                return rtn;
            }
            return rt;
        }
        return null;
    }

    private Map<PsSkuVO, Integer> mapPresaleSkuStock(List<PsSkuVO> skus, boolean isCombined, boolean isOversea) {
        if (!isCombined && !isOversea) {
            HashMap rt = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(skus)) {
                HashMap mapSkuCodes = Maps.newHashMap();
                for (PsSkuVO sku : skus) {
                    if (sku == null) continue;
                    mapSkuCodes.put(sku.getSkuCode(), sku);
                }
                Integer stock = 0;
                Map presaleMap = null;
                if (mapSkuCodes.size() > 0) {
                    ArrayList presaleSkuCodes = Lists.newArrayList(mapSkuCodes.keySet());
                    presaleMap = this.poInstance.findCanUseQttBySkuCodes((List)presaleSkuCodes, null);
                    for (String code : presaleSkuCodes) {
                        OpPresaleSaleInvVO presale = presaleMap != null ? (OpPresaleSaleInvVO)presaleMap.get(code) : null;
                        int presaleCount = presale == null ? 0 : presale.getCanUseInv();
                        stock = presaleCount;
                        PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                        rt.put(sku, stock);
                    }
                }
            }
            return rt;
        }
        return null;
    }

    private Map<PsSkuVO, Integer> mapNormalSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea) {
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus)) {
            HashMap mapSkuCodes = Maps.newHashMap();
            for (PsSkuVO sku : skus) {
                if (sku == null || this.checkIsJIT(sku)) continue;
                mapSkuCodes.put(sku.getSkuCode(), sku);
            }
            Integer stock = 0;
            if (mapSkuCodes.keySet().size() > 0) {
                ArrayList skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
                Map<PsSkuVO, Integer> presaleMap = this.mapPresaleSkuStock(Lists.newArrayList(mapSkuCodes.values()), isCombined, isOversea);
                Map map = this.sStockService.getSkuStocks((List)skuCodes, warehouseCode);
                for (String code : skuCodes) {
                    PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                    SSkuStockVO warehouse = map != null ? (SSkuStockVO)map.get(code) : null;
                    int presaleCount = presaleMap != null ? presaleMap.get(sku) : 0;
                    int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseQuantity();
                    stock = presaleCount + warehouseCount;
                    rt.put(sku, stock);
                }
            }
        }
        return rt;
    }

    private Map<PsSkuVO, Integer> mapNormalSkuStockOptimize(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus)) {
            HashMap mapSkuCodes = Maps.newHashMap();
            for (PsSkuVO sku : skus) {
                if (sku == null) continue;
                if (!this.checkIsJIT(sku)) {
                    mapSkuCodes.put(sku.getSkuCode(), sku);
                    continue;
                }
                rt.put(sku, Integer.MAX_VALUE);
            }
            Integer stock = 0;
            if (mapSkuCodes.keySet().size() > 0) {
                ArrayList skuCodes = Lists.newArrayList(mapSkuCodes.keySet());
                for (String code : skuCodes) {
                    PsSkuVO sku = (PsSkuVO)mapSkuCodes.get(code);
                    if (presaleVOMap != null && presaleVOMap.get(code) != null) {
                        stock = Integer.MAX_VALUE;
                    } else {
                        SSkuStockVO warehouse = warehouseMap != null ? warehouseMap.get(code) : null;
                        int warehouseCount = warehouse == null ? 0 : warehouse.getCanUseQuantity();
                        stock = warehouseCount;
                    }
                    rt.put(sku, stock);
                }
            }
        }
        return rt;
    }

    private Map<PsSkuVO, Integer> mapSkuStockOptimize(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        Map<PsSkuVO, Integer> mapNormalSkuStock;
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus) && (mapNormalSkuStock = this.mapNormalSkuStockOptimize(skus, warehouseCode, isCombined, isOversea, presaleVOMap, warehouseMap)) != null) {
            rt.putAll(mapNormalSkuStock);
        }
        return rt;
    }

    @Deprecated
    private Map<PsSkuVO, Integer> mapSkuStock(List<PsSkuVO> skus, String warehouseCode, boolean isCombined, boolean isOversea) {
        HashMap rt = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skus)) {
            Map<PsSkuVO, Integer> mapNormalSkuStock;
            Map<PsSkuVO, Integer> mapJITSkuStock = this.mapJITSkuStock(skus, isCombined, warehouseCode);
            if (mapJITSkuStock != null) {
                rt.putAll(mapJITSkuStock);
            }
            if ((mapNormalSkuStock = this.mapNormalSkuStock(skus, warehouseCode, isCombined, isOversea)) != null) {
                rt.putAll(mapNormalSkuStock);
            }
        }
        return rt;
    }

    @Override
    public boolean isSellout(PsSpvVO spv, String warehouseCode) {
        if (spv != null) {
            Integer stock = this.getSpvStock(spv, warehouseCode);
            Integer minAmount = spv.getMinAmount() != null && spv.getMinAmount() != 0 ? spv.getMinAmount() : 1;
            if (stock != null && (stock <= 0 || stock / minAmount <= 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer getSpvStock(PsSpvVO spv, String warehouseCode) {
        Map<PsSkuVO, Integer> mapSkuStock;
        Date start = new Date();
        Integer stock = null;
        ArrayList codes = Lists.newArrayList();
        HashMap skuQuantityMap = Maps.newHashMap();
        boolean isCombined = false;
        boolean isOversea = false;
        if (spv.getCombined().booleanValue()) {
            isCombined = true;
            List skuComns = spv.getSkuCombinationList();
            if (CollectionUtils.isNotEmpty((Collection)skuComns)) {
                for (PsSkuCombinationVO skuComn : skuComns) {
                    codes.add(skuComn.getSubSkuCode());
                    skuQuantityMap.put(skuComn.getSubSkuCode(), skuComn.getQuantity());
                }
            }
        } else {
            isCombined = false;
            codes.add(spv.getSkuCode());
        }
        List skus = this.mcPsSkuService.findBySkuCodes((List)codes);
        for (Object sku : skus) {
            if (sku.getCrossBorderFlag() == null || !sku.getCrossBorderFlag().equals(1)) continue;
            isOversea = true;
            break;
        }
        if ((mapSkuStock = this.mapSkuStock(skus, warehouseCode, isCombined, isOversea)) != null && mapSkuStock.size() > 0) {
            for (Map.Entry entry : mapSkuStock.entrySet()) {
                Integer quantity;
                Integer tempStock = (Integer)entry.getValue();
                if (tempStock == null || tempStock < 0) {
                    tempStock = 0;
                }
                if ((quantity = (Integer)skuQuantityMap.get(((PsSkuVO)entry.getKey()).getSkuCode())) != null && !quantity.equals(0)) {
                    tempStock = tempStock / quantity;
                }
                if (stock != null) {
                    if (stock <= tempStock) continue;
                    stock = tempStock;
                    continue;
                }
                stock = tempStock;
            }
        }
        Date end = new Date();
        this.logger.info("\u65b9\u6cd5getSpvStock\u82b1\u8d39\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
        return stock != null ? stock : 0;
    }

    @Override
    public Map<PsSpvVO, Boolean> mapSpvsIsSellout(Collection<PsSpvVO> spvs, String warehouseCode) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(spvs)) {
            for (PsSpvVO spv : spvs) {
                map.put(spv, this.isSellout(spv, warehouseCode));
            }
        }
        return map;
    }

    @Override
    public Map<PsSpvVO, Integer> mapSpvsStock(Collection<PsSpvVO> spvs, String warehouseCode) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(spvs)) {
            for (PsSpvVO spv : spvs) {
                map.put(spv, this.getSpvStock(spv, warehouseCode));
            }
        }
        return map;
    }

    @Override
    public Map<PsSpvVO, Integer> mapSpvsStockOptimize(Collection<PsSpvVO> spvs, String warehouseCode, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (CollectionUtils.isNotEmpty(spvs)) {
            for (PsSpvVO spv : spvs) {
                map.put(spv, this.getSpvStockOptimize(spv, warehouseCode, psSkuVOMap, presaleVOMap, warehouseMap));
            }
        }
        return map;
    }

    private Integer getSpvStockOptimize(PsSpvVO spv, String warehouseCode, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        Map<PsSkuVO, Integer> mapSkuStock;
        Date start = new Date();
        Integer stock = null;
        ArrayList codes = Lists.newArrayList();
        HashMap skuQuantityMap = Maps.newHashMap();
        boolean isCombined = false;
        boolean isOversea = false;
        if (spv.getCombined().booleanValue()) {
            isCombined = true;
            List skuComns = spv.getSkuCombinationList();
            if (CollectionUtils.isNotEmpty((Collection)skuComns)) {
                for (PsSkuCombinationVO psSkuCombinationVO : skuComns) {
                    codes.add(psSkuCombinationVO.getSubSkuCode());
                    skuQuantityMap.put(psSkuCombinationVO.getSubSkuCode(), psSkuCombinationVO.getQuantity());
                }
            }
        } else {
            isCombined = false;
            codes.add(spv.getSkuCode());
        }
        List<PsSkuVO> skus = this.getPsSkuVOByMap(codes, psSkuVOMap);
        for (PsSkuVO psSkuVO : skus) {
            if (psSkuVO.getCrossBorderFlag() == null || !psSkuVO.getCrossBorderFlag().equals(1)) continue;
            isOversea = true;
            break;
        }
        if ((mapSkuStock = this.mapSkuStockOptimize(skus, warehouseCode, isCombined, isOversea, presaleVOMap, warehouseMap)) != null && mapSkuStock.size() > 0) {
            for (Map.Entry<PsSkuVO, Integer> entry : mapSkuStock.entrySet()) {
                Integer quantity;
                Integer tempStock = entry.getValue();
                if (tempStock == null || tempStock < 0) {
                    tempStock = 0;
                }
                if ((quantity = (Integer)skuQuantityMap.get(entry.getKey().getSkuCode())) != null && !quantity.equals(0)) {
                    tempStock = tempStock / quantity;
                }
                if (stock != null) {
                    if (stock <= tempStock) continue;
                    stock = tempStock;
                    continue;
                }
                stock = tempStock;
            }
        }
        Date date = new Date();
        this.logger.info("\u65b9\u6cd5getSpvStock\u82b1\u8d39\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(date.getTime() - start.getTime()));
        return stock != null ? stock : 0;
    }

    private List<PsSkuVO> getPsSkuVOByMap(List<String> codes, Map<String, PsSkuVO> psSkuVOMap) {
        ArrayList<PsSkuVO> ps = new ArrayList<PsSkuVO>();
        for (String code : codes) {
            PsSkuVO psSkuVO = psSkuVOMap.get(code);
            if (null != psSkuVO) {
                ps.add(psSkuVO);
                continue;
            }
            this.logger.error("getPsSkuVOByMap skucode \u5f02\u5e38");
        }
        return ps;
    }
}

