/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.delivery.service.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.delivery.dao.DeliveryDistrictDao;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.service.DeliveryDistrictService;
import com.thebeastshop.pegasus.util.PegasusUtilFacade;
import com.thebeastshop.pegasus.util.model.CommDistrict;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryDistrictServiceImpl
implements DeliveryDistrictService {
    private static List<String> fedexNotDeliveryAreas = new ArrayList<String>();
    private static Map<String, List<String>> prodCodeDeliveryAreas = new HashMap<String, List<String>>();
    @Autowired
    private DeliveryDistrictDao dao;

    @Override
    public boolean checkDelivery(DeliveryType type, long districtId) {
        if (type != null) {
            List<Long> districtIds;
            ArrayList types = Lists.newArrayList((Object[])new DeliveryType[]{type});
            if (type.equals((Object)DeliveryType.FEDEX)) {
                CommDistrict district = PegasusUtilFacade.getInstance().findDistrictById(Long.valueOf(districtId));
                if (fedexNotDeliveryAreas.contains(district.getName())) {
                    return false;
                }
                types.add(DeliveryType.SELF);
            }
            if ((districtIds = this.dao.getDistrictIds(types)).contains(districtId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkDelivery(String productCode, long districtId) {
        boolean flag = true;
        if (prodCodeDeliveryAreas.containsKey(productCode)) {
            List<String> deliveryAreas = prodCodeDeliveryAreas.get(productCode);
            CommDistrict district = PegasusUtilFacade.getInstance().findDistrictById(Long.valueOf(districtId));
            String districtFullName = district.getFullName();
            flag = false;
            for (String s : deliveryAreas) {
                if (!districtFullName.contains(s)) continue;
                return true;
            }
        }
        return flag;
    }

    static {
        fedexNotDeliveryAreas.add("\u77f3\u666f\u5c71\u533a");
        fedexNotDeliveryAreas.add("\u95e8\u5934\u6c9f\u533a");
        fedexNotDeliveryAreas.add("\u623f\u5c71\u533a");
        fedexNotDeliveryAreas.add("\u660c\u5e73\u533a");
        fedexNotDeliveryAreas.add("\u5927\u5174\u533a");
        fedexNotDeliveryAreas.add("\u6000\u67d4\u533a");
        fedexNotDeliveryAreas.add("\u5e73\u8c37\u533a");
        fedexNotDeliveryAreas.add("\u5bc6\u4e91\u53bf");
        fedexNotDeliveryAreas.add("\u5ef6\u5e86\u53bf");
        prodCodeDeliveryAreas.put("PROD001019595", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac"}));
        prodCodeDeliveryAreas.put("PROD001019596", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac"}));
        prodCodeDeliveryAreas.put("PROD001019635", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac", "\u676d\u5dde", "\u5357\u4eac", "\u6210\u90fd", "\u5e7f\u5dde", "\u6df1\u5733", "\u6c88\u9633"}));
        prodCodeDeliveryAreas.put("PROD001019636", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac", "\u676d\u5dde", "\u5357\u4eac", "\u6210\u90fd", "\u5e7f\u5dde", "\u6df1\u5733", "\u6c88\u9633"}));
        prodCodeDeliveryAreas.put("PROD001018331", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac", "\u56db\u5ddd", "\u6d59\u6c5f", "\u5e7f\u4e1c", "\u6c5f\u82cf", "\u8fbd\u5b81"}));
        prodCodeDeliveryAreas.put("PROD001020432", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u5317\u4eac", "\u6d59\u6c5f", "\u6c5f\u82cf", "\u5b89\u5fbd", "\u6cb3\u5317", "\u5929\u6d25"}));
        prodCodeDeliveryAreas.put("PROD001020433", Lists.newArrayList((Object[])new String[]{"\u4e0a\u6d77", "\u6d59\u6c5f", "\u6c5f\u82cf", "\u5b89\u5fbd"}));
    }
}

