/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.category.service.impl;

import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.dao.CategoryDao;
import com.thebeastshop.pegasus.component.category.dao.CategoryFrontDao;
import com.thebeastshop.pegasus.component.category.service.CategoryFrontService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryFrontServieImpl
implements CategoryFrontService {
    private static final Logger logger = LoggerFactory.getLogger(CategoryFrontServieImpl.class);
    @Autowired
    private CategoryFrontDao categoryFrontDao;
    @Autowired
    private CategoryDao categoryDao;

    @Override
    public List<CategoryFront> getFirstLevelCategories() {
        List<CategoryFront> CategoryFrontList = this.categoryFrontDao.getFirstCategory();
        return CategoryFrontList;
    }

    @Override
    public List<Long> getCategoryIdsByCodes(List<String> categoryCode) {
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(categoryCode)) {
            ArrayList<String> categorycodes = new ArrayList<String>();
            categorycodes.addAll(categoryCode);
            int i = 0;
            do {
                List<CategoryFront> categoryFronts = this.categoryFrontDao.getLeftCategorIdsByCodes(categorycodes);
                ArrayList<String> c = new ArrayList<String>();
                for (CategoryFront categoryFront : categoryFronts) {
                    categoryIds.add(categoryFront.getId());
                    c.add(categoryFront.getCode());
                }
                categorycodes.removeAll(c);
                if (CollectionUtils.isNotEmpty(categorycodes)) {
                    List<String> bcsd = this.categoryFrontDao.getCategoryCodeBycode(categorycodes);
                    if (CollectionUtils.isNotEmpty(bcsd)) {
                        categorycodes.clear();
                        categorycodes.addAll(bcsd);
                    } else {
                        categorycodes.clear();
                        logger.info("===\u5206\u7c7b\u67e5\u8be2\u5f02\u5e38");
                    }
                }
                logger.info("===\u67e5\u8be2\u6761\u4ef6  categorycodes={} ", categorycodes);
            } while (++i != 5 && !categorycodes.isEmpty());
        }
        return categoryIds;
    }

    @Override
    public List<CategoryFront> getCategoriesByIds(List<Long> categoryIds) {
        List<CategoryFront> CategoryFrontList = this.categoryFrontDao.getCategoryFrontisById(categoryIds);
        return CategoryFrontList;
    }

    @Override
    public List<CategoryFront> getCategoriesByParentId(Integer parentId) {
        List<CategoryFront> CategoryFrontList = this.categoryFrontDao.getCategoriesByParentId(parentId);
        return CategoryFrontList;
    }

    @Override
    public List<Long> getAllCategories() {
        ArrayList<Long> CategoryFrontList = new ArrayList();
        CategoryFrontList = this.categoryFrontDao.getAllCategories();
        return CategoryFrontList;
    }
}

