/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.support.BuyQuota;
import com.thebeastshop.cart.support.DefaultProductPackImpl;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;
import com.thebeastshop.pegasus.component.campaign.LadderRuleEnum;
import com.thebeastshop.pegasus.component.campaign.service.CampaignService;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.product.warehouse.service.ProductWarehouseService;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.warehouse.PegasusWarehouseServiceFacade;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CampaignServiceImpl
implements CampaignService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McPsSpvService mcPsSpvService;
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private ProductWarehouseService productWarehouseService;
    @Autowired
    private McPsSkuService mcPsSkuService;
    private PegasusWarehouseServiceFacade warehouseService = PegasusWarehouseServiceFacade.getInstance();
    @Autowired
    private CampaignLimitService campaignLimitService;
    @Autowired
    private SPresaleService sPresaleService;
    @Autowired
    private SStockService sStockService;

    private List<CampaignHandler> sortCampaignHandlers(List<CampaignHandler> handlers) {
        Collections.sort(handlers, new Comparator<CampaignHandler>(){

            @Override
            public int compare(CampaignHandler o1, CampaignHandler o2) {
                Campaign campaign1 = o1.getCampaign();
                Campaign campaign2 = o2.getCampaign();
                DiscountType discountType1 = campaign1.getDiscountType();
                DiscountType discountType2 = campaign2.getDiscountType();
                int i = discountType1.getSort().compareTo(discountType2.getSort());
                if (i == 0 && (i = campaign1.getProductScope().getId().compareTo(campaign2.getProductScope().getId())) == 0 && campaign1.getCreateTime() != null && campaign2.getCreateTime() != null) {
                    i = campaign1.getCreateTime().compareTo(campaign2.getCreateTime());
                }
                return i;
            }
        });
        return handlers;
    }

    private CampaignResult handleOneCampaign(CampaignHandler handler, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        Campaign campaign = handler.getCampaign();
        List<ProductPack> participatingPacks = handler.getParticipatingPacks();
        List<ProductPack> nonParticipatingPacks = handler.getNonParticipatingPacks();
        if (participatingPacks.isEmpty()) {
            return CampaignServiceImpl.empty(campaign, nonParticipatingPacks, preFinalPriceMap);
        }
        return this.checkCondition(campaign, participatingPacks, nonParticipatingPacks, preFinalPriceMap, channel);
    }

    private static List<CampaignSection> matchedConditionSections(Campaign campaign, BigDecimal price, int count) {
        List<CampaignSection> campaignSections = campaign.getCampaignSections();
        ArrayList rt = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(campaignSections)) {
            CampaignSection maxLineSection = null;
            for (CampaignSection campaignSection : campaignSections) {
                if (!campaignSection.getConditionType().matchCondition(price, count, campaignSection.getLine())) continue;
                rt.add(campaignSection);
                if (maxLineSection != null && maxLineSection.getLine().compareTo(campaignSection.getLine()) != -1) continue;
                maxLineSection = campaignSection;
            }
            if ((!DiscountType.GIFT.equals((Object)campaign.getDiscountType()) && !DiscountType.CHEAPEN_OTHER.equals((Object)campaign.getDiscountType()) || LadderRuleEnum.MAX_LADDER.equals((Object)campaign.getLadderRule())) && maxLineSection != null) {
                rt.clear();
                rt.add(maxLineSection);
            }
            Collections.sort(rt, CampaignSection.DESC);
        }
        return rt;
    }

    private static CampaignSection findFirstMatch(Collection<CampaignSection> campaignSections, BigDecimal price, int count) {
        for (CampaignSection e : campaignSections) {
            if (!e.getConditionType().matchCondition(price, count, e.getLine())) continue;
            return e;
        }
        return null;
    }

    private CampaignResult checkCondition(Campaign campaign, List<ProductPack> participatingPacks, Collection<ProductPack> nonParticipatingPacks, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        List<CampaignSection> campaignSections;
        BigDecimal participatingPrice = BigDecimal.ZERO;
        int participatingCount = 0;
        if (CollectionUtils.isNotEmpty(participatingPacks)) {
            for (ProductPack productPack : participatingPacks) {
                participatingCount += productPack.getCount();
                BigDecimal finalPrice = preFinalPriceMap.get(productPack);
                if (finalPrice == null) {
                    participatingPrice = participatingPrice.add(productPack.getPrice());
                    continue;
                }
                participatingPrice = participatingPrice.add(finalPrice.multiply(BigDecimal.valueOf(productPack.getCount())));
            }
        }
        if ((campaignSections = CampaignServiceImpl.matchedConditionSections(campaign, participatingPrice = PriceUtil.keepToCent((BigDecimal)participatingPrice), participatingCount)).isEmpty()) {
            return CampaignServiceImpl.notReach(campaign, participatingPacks, nonParticipatingPacks, participatingPrice, participatingCount, preFinalPriceMap);
        }
        return this.campaignAffect(campaign, participatingPrice, participatingCount, participatingPacks, nonParticipatingPacks, campaignSections, preFinalPriceMap, channel);
    }

    private static CampaignResult notReach(Campaign campaign, Collection<ProductPack> participatePacks, Collection<ProductPack> nonParticipatingPacks, BigDecimal participatePrice, int participateCount, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        return new CampaignResult.DefaultCampaignResultImpl(campaign, false, participatePacks, participatePrice, preFinalPriceMap, preFinalPriceMap, nonParticipatingPacks, participatePrice, Lists.newArrayList());
    }

    private static void addRawPriceToFinalPriceMap(Map<ProductPack, BigDecimal> finalPriceMap, List<? extends ProductPack> packs) {
        for (ProductPack productPack : packs) {
            finalPriceMap.put(productPack, productPack.getFactProductPrice());
        }
    }

    private CampaignResult campaignAffect(Campaign campaign, BigDecimal participatingPrice, int participatingCount, List<ProductPack> participatingPacks, Collection<ProductPack> nonParticipatingPacks, List<CampaignSection> campaignSections, Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel) {
        BigDecimal participatedPrice = participatingPrice;
        ArrayList additionalPacks = Lists.newArrayList();
        HashMap finalPriceMap = Maps.newHashMap(preFinalPriceMap);
        DiscountType discountType = campaign.getDiscountType();
        HashMap<String, PsSkuVO> psSkuVOMap = new HashMap<String, PsSkuVO>();
        HashMap<String, SPresaleVO> presaleVOMap = new HashMap<String, SPresaleVO>();
        HashMap<String, SSkuStockVO> warehouseMap = new HashMap<String, SSkuStockVO>();
        if (campaign.isCumulative().booleanValue()) {
            CampaignSection campaignSection = CampaignServiceImpl.findFirstMatch(campaignSections, participatingPrice, participatingCount);
            ArrayList<CampaignSection> campaignSections1 = new ArrayList<CampaignSection>();
            campaignSections1.add(campaignSection);
            Map<Long, PsProductVO> psProductVOMap = this.findPsProductVOByCampaignIds(campaignSections1, psSkuVOMap, presaleVOMap, warehouseMap, channel);
            assert (campaignSection != null);
            int times = campaignSection.getConditionType().cumulate(campaignSection.getLine(), participatingPrice, participatingCount);
            if (discountType.isForceParticipate()) {
                if (discountType.isAffectPrice()) {
                    participatedPrice = discountType.handlePrice(participatingPacks, campaignSection, participatingPrice, times, finalPriceMap, preFinalPriceMap);
                }
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, channel, psProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap);
            } else {
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, channel, psProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap);
            }
        } else {
            boolean first = true;
            Map<Long, PsProductVO> psProductVOMap = this.findPsProductVOByCampaignIds(campaignSections, psSkuVOMap, presaleVOMap, warehouseMap, channel);
            for (CampaignSection campaignSection : campaignSections) {
                boolean times = true;
                if (discountType.isForceParticipate()) {
                    if (first) {
                        first = false;
                        if (discountType.isAffectPrice()) {
                            participatedPrice = discountType.handlePrice(participatingPacks, campaignSection, participatingPrice, 1, finalPriceMap, preFinalPriceMap);
                        }
                    }
                    this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, 1, channel, psProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap);
                    continue;
                }
                this.affectAdditionalPacks(campaign, additionalPacks, campaignSection, 1, channel, psProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap);
            }
        }
        return new CampaignResult.DefaultCampaignResultImpl(campaign, true, participatingPacks, participatingPrice, preFinalPriceMap, finalPriceMap, nonParticipatingPacks, participatedPrice, additionalPacks);
    }

    private Map<Long, PsProductVO> findPsProductVOByCampaignIds(List<CampaignSection> campaignSections, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap, Channel channel) {
        HashMap<Long, PsProductVO> returnPsProductVOMap = new HashMap<Long, PsProductVO>();
        if (CollectionUtils.isNotEmpty(campaignSections)) {
            ArrayList<CampaignSectionProduct> campaignSectionProducts = new ArrayList<CampaignSectionProduct>();
            ArrayList<String> additionalProductIds = new ArrayList<String>();
            ArrayList<Long> productSpvIds = new ArrayList<Long>();
            for (CampaignSection campaignSection : campaignSections) {
                campaignSectionProducts.addAll(campaignSection.getCampaignSectionProducts());
            }
            for (CampaignSectionProduct campaignSectionProduct : campaignSectionProducts) {
                additionalProductIds.add(campaignSectionProduct.getAdditionalProductId() + "");
            }
            if (CollectionUtils.isNotEmpty(additionalProductIds)) {
                PsProductCond psProductCond = new PsProductCond();
                psProductCond.setIds(additionalProductIds);
                psProductCond.setPagenum(Integer.valueOf(additionalProductIds.size()));
                ArrayList<PsProductVO> psProductVOs = new ArrayList<PsProductVO>();
                psProductVOs.addAll(this.mcPsProductService.findByCond(psProductCond));
                for (PsProductVO psProductVO : psProductVOs) {
                    for (PsSpvVO psSpvVO : psProductVO.getSpvList()) {
                        productSpvIds.add(psSpvVO.getSpvId());
                    }
                }
                if (CollectionUtils.isNotEmpty(productSpvIds)) {
                    ArrayList<PsSpvVO> spvVOs = new ArrayList<PsSpvVO>();
                    spvVOs.addAll(this.mcPsSpvService.findBySpvIdsWithStock(productSpvIds, channel.getCode()));
                    this.convertPsProductVOs(psProductVOs, spvVOs, returnPsProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap, channel.getWarehouseCode());
                }
            }
        }
        return returnPsProductVOMap;
    }

    private void convertPsProductVOs(List<PsProductVO> psProductVOs, List<PsSpvVO> spvVOs, Map<Long, PsProductVO> returnPsProductVOMap, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap, String warehouseCode) {
        Long start = System.currentTimeMillis();
        HashMap<Long, PsSpvVO> spvVOMap = new HashMap<Long, PsSpvVO>();
        ArrayList<String> skuCodes = new ArrayList<String>();
        for (PsSpvVO psSpvVO : spvVOs) {
            spvVOMap.put(psSpvVO.getSpvId(), psSpvVO);
            if (psSpvVO.getCombined().booleanValue()) {
                List skuComns = psSpvVO.getSkuCombinationList();
                if (!CollectionUtils.isNotEmpty((Collection)skuComns)) continue;
                for (PsSkuCombinationVO skuComn : skuComns) {
                    skuCodes.add(skuComn.getSubSkuCode());
                }
                continue;
            }
            skuCodes.add(psSpvVO.getSkuCode());
        }
        List skus = this.mcPsSkuService.findBySkuCodes(skuCodes);
        presaleVOMap.putAll(this.sPresaleService.findAvaliableBySkuCodes(skuCodes, Boolean.valueOf(false)));
        warehouseMap.putAll(this.sStockService.getSkuStocks(skuCodes, warehouseCode));
        for (PsSkuVO psSkuVO : skus) {
            psSkuVOMap.put(psSkuVO.getSkuCode(), psSkuVO);
        }
        for (PsProductVO psProductVO : psProductVOs) {
            ArrayList<PsSpvVO> psSpvVOs = new ArrayList<PsSpvVO>();
            for (PsSpvVO psSpvVO : psProductVO.getSpvList()) {
                PsSpvVO psSpvVOByMap = (PsSpvVO)spvVOMap.get(psSpvVO.getSpvId());
                if (null == psSpvVOByMap) continue;
                psSpvVOs.add(psSpvVOByMap);
            }
            if (CollectionUtils.isNotEmpty(psSpvVOs)) {
                psProductVO.setSpvList(psSpvVOs);
            }
            returnPsProductVOMap.put(Long.valueOf(psProductVO.getId()), psProductVO);
        }
    }

    private void affectAdditionalPacks(Campaign campaign, Collection<ProductPack> additionalPacks, CampaignSection campaignSection, int times, Channel channel, Map<Long, PsProductVO> psProductVOMap, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        List<CampaignSectionProduct> campaignSectionProducts = campaignSection.getCampaignSectionProducts();
        if (CollectionUtils.isNotEmpty(campaignSectionProducts)) {
            ArrayList productIds = Lists.newArrayList();
            for (CampaignSectionProduct temp : campaignSectionProducts) {
                productIds.add(temp.getAdditionalProductId());
            }
            for (int i = 0; i < campaignSectionProducts.size(); ++i) {
                ProductPack additionalPack;
                CampaignSectionProduct campaignSectionProduct = campaignSectionProducts.get(i);
                boolean isLastSectionProduct = false;
                if (i >= campaignSectionProducts.size() - 1) {
                    isLastSectionProduct = true;
                }
                if ((additionalPack = this.checkCampaignSectionProduct(campaign, campaignSection, campaignSectionProduct, times, channel, isLastSectionProduct, psProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap)) == null) continue;
                additionalPacks.add(additionalPack);
            }
        }
    }

    private ProductPack checkCampaignSectionProduct(Campaign campaign, CampaignSection campaignSection, CampaignSectionProduct campaignSectionProduct, int times, Channel channel, boolean isLastSectionProduct, Map<Long, PsProductVO> psProductVOMap, Map<String, PsSkuVO> psSkuVOMap, Map<String, SPresaleVO> presaleVOMap, Map<String, SSkuStockVO> warehouseMap) {
        Long additionalProductId = campaignSectionProduct.getAdditionalProductId();
        DiscountType discountType = campaign.getDiscountType();
        if (additionalProductId != null) {
            PsProductVO additionalProduct = psProductVOMap.get(additionalProductId);
            if (additionalProduct != null) {
                List spvs = additionalProduct.getSpvList();
                if (CollectionUtils.isEmpty((Collection)spvs)) {
                    throw new NoSuchResourceException("\u6821\u9a8c\u6d3b\u52a8\u533a\u95f4\u989d\u5916\u5546\u54c1\u662f\u5426\u6ee1\u8db3\u7684\u65b9\u6cd5\u51fa\u9519\u4e86, \u5546\u54c1\u4e0b\u9762\u7684spv\u90fd\u6ca1\u6709\u4e86", "productId", (Object)additionalProductId);
                }
                boolean limitflag = false;
                CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
                campaignStreamVO.setCampaignCode(campaign.getCode());
                campaignStreamVO.setProductCode(additionalProduct.getCode());
                ServiceResp resp = this.campaignLimitService.checkCspLimit(campaignStreamVO);
                if (resp.isSuccess()) {
                    limitflag = (Boolean)resp.getBean();
                }
                PsSpvVO maxStockSpv = (PsSpvVO)spvs.get(0);
                Integer tempStock = 0;
                if (!limitflag) {
                    Map<PsSpvVO, Integer> spvStockMap = this.productWarehouseService.mapSpvsStockOptimize(spvs, channel.getWarehouseCode(), psSkuVOMap, presaleVOMap, warehouseMap);
                    for (PsSpvVO spv : spvs) {
                        Integer stock = spvStockMap.get(spv);
                        if (stock <= tempStock) continue;
                        tempStock = stock;
                        maxStockSpv = spv;
                    }
                }
                if (tempStock > 0 || DiscountType.GIFT == discountType) {
                    DefaultProductPackImpl additionalPack = new DefaultProductPackImpl();
                    additionalPack.setProductId(Long.valueOf(additionalProduct.getId()));
                    additionalPack.setSpvId(maxStockSpv.getSpvId());
                    BigDecimal additionalProductPrice = campaignSectionProduct.getAdditionalProductPrice();
                    if (additionalProductPrice == null) {
                        additionalPack.setFactProductPrice(additionalProduct.getListPrice());
                    } else {
                        additionalPack.setFactProductPrice(additionalProductPrice);
                    }
                    Integer maxCount = tempStock;
                    Integer count = campaignSectionProduct.getLimitCount() == null ? 1 : campaignSectionProduct.getLimitCount();
                    additionalPack.setLimitCount(count);
                    if (count == -1) {
                        count = 1 * times;
                    } else {
                        maxCount = count = Integer.valueOf(campaignSectionProduct.getLimitCount() * times);
                        if (count > tempStock) {
                            count = tempStock;
                        }
                    }
                    BuyQuota buyQuota = new BuyQuota(maxCount, maxCount, Integer.valueOf(0));
                    if (discountType == DiscountType.GIFT) {
                        additionalPack.setSource(CartPackSource.GIFT);
                    } else if (discountType == DiscountType.CHEAPEN_OTHER) {
                        additionalPack.setSource(CartPackSource.ADDIBLE);
                        count = 1;
                    }
                    if (campaignSectionProduct.getLimitCount() != null && campaignSectionProduct.getLimitCount() == -1) {
                        buyQuota = null;
                    }
                    additionalPack.setBuyQuota(buyQuota);
                    additionalPack.setCount(count.intValue());
                    additionalPack.setSpv(maxStockSpv);
                    additionalPack.setProduct(additionalProduct);
                    return additionalPack;
                }
            } else {
                this.logger.warn("\u6d3b\u52a8\u6307\u5b9a\u7684\u989d\u5916\u5546\u54c1" + additionalProductId + "\u4e0d\u5b58\u5728");
            }
        }
        return null;
    }

    private static CampaignResult empty(Campaign campaign, Collection<ProductPack> nonParticipatingPacks, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        return new CampaignResult.DefaultCampaignResultImpl(campaign, false, Lists.newArrayList(), BigDecimal.ZERO, preFinalPriceMap, preFinalPriceMap, nonParticipatingPacks, BigDecimal.ZERO, Lists.newArrayList());
    }

    @Override
    public List<CampaignResult> match(List<CampaignHandler> handlers, List<? extends ProductPack> productPacks, Channel channel) {
        Date start = new Date();
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        handlers = this.sortCampaignHandlers(handlers);
        ArrayList rt = Lists.newArrayListWithExpectedSize((int)handlers.size());
        ArrayList preResultPacks = productPacks;
        Map<Object, Object> preFinalPriceMap = Maps.newHashMap();
        CampaignServiceImpl.addRawPriceToFinalPriceMap(preFinalPriceMap, preResultPacks);
        if (CollectionUtils.isNotEmpty(handlers)) {
            for (CampaignHandler handler : handlers) {
                CampaignResult campaignResult = this.handleOneCampaign(handler, preFinalPriceMap, channel);
                Collection<ProductPack> participators = campaignResult.getOwnedPacks();
                ArrayList curResultPacks = Lists.newArrayList(participators);
                if (CollectionUtils.isNotEmpty(preResultPacks)) {
                    for (ProductPack preResultPack : preResultPacks) {
                        if (participators.contains(preResultPack)) continue;
                        curResultPacks.add(preResultPack);
                    }
                }
                rt.add(campaignResult);
                preFinalPriceMap = campaignResult.getFinalPriceMap();
                preResultPacks = curResultPacks;
            }
        }
        Date end = new Date();
        this.logger.info("\u6d3b\u52a8\u5339\u914d\u82b1\u8d39\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
        return rt;
    }
}

