/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign;

import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;
import java.math.BigDecimal;
import java.math.RoundingMode;

public enum ConditionType implements HasIdGetter.HasIntIdGetter,
HasName
{
    PRICE(1, "\u91d1\u989d"){

        @Override
        public boolean matchCondition(BigDecimal price, int productCount, BigDecimal conditionNum) {
            if (conditionNum.compareTo(BigDecimal.ZERO) <= 0) {
                return true;
            }
            return price.compareTo(conditionNum) >= 0;
        }

        @Override
        public int cumulate(BigDecimal line, BigDecimal participatePrice, int participateCount) {
            return participatePrice.divide(line, RoundingMode.HALF_UP).intValue();
        }
    }
    ,
    PRODUCT_COUNT(2, "\u5546\u54c1\u6570\u91cf"){

        @Override
        public boolean matchCondition(BigDecimal price, int productCount, BigDecimal conditionNum) {
            if (conditionNum.compareTo(BigDecimal.ZERO) <= 0) {
                return true;
            }
            return productCount >= conditionNum.intValue();
        }

        @Override
        public int cumulate(BigDecimal line, BigDecimal participatePrice, int participateCount) {
            return participateCount / line.intValue();
        }
    };

    public final Integer id;
    public final String name;

    private ConditionType(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public abstract boolean matchCondition(BigDecimal var1, int var2, BigDecimal var3);

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract int cumulate(BigDecimal var1, BigDecimal var2, int var3);
}

