/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.logistics.service.impl;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.logistics.config.SFConfig;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRequest;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRequestBody;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRoute;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRouteRequest;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.SFService;
import com.thebeastshop.support.encode.Base64Util;
import com.thebeastshop.support.encode.MD5Util;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.XmlUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SFServiceImpl
extends BaseService
implements SFService {
    private final String CHARSET = "UTF-8";

    @Override
    public SFResponse queryByCode(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new WrongArgException("\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "LogisticCode", (Object)code);
        }
        try {
            SFRequest request = new SFRequest();
            request.setService(SFConfig.ROUTE_SERVICE);
            request.setLang(SFConfig.LANG_CN);
            request.setHead(SFConfig.ENVI_CODE);
            SFRouteRequest routeRequest = new SFRouteRequest();
            routeRequest.setMethodType(SFConfig.METHOD_TYPE);
            routeRequest.setTrackingType(SFConfig.TRACKING_TYPE);
            routeRequest.setTrackingNumber(code);
            SFRequestBody body = new SFRequestBody();
            body.setRouteRequest(routeRequest);
            request.setBody(body);
            String xml = XmlUtil.toXml((Object)request);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("xml", xml);
            String verifyCode = Base64Util.encode((byte[])MD5Util.md5ToBytes((String)(xml + SFConfig.CHECKWORD)));
            params.put("verifyCode", verifyCode);
            this.logger.info("\u67e5\u8be2\u987a\u4e30\u5feb\u9012\u7269\u6d41\u8bf7\u6c42\u4fe1\u606f: {}", params);
            String responseXml = HttpUtil.doFormPost((String)SFConfig.URL, params, (String)"UTF-8");
            this.logger.info("\u67e5\u8be2\u987a\u4e30\u5feb\u9012\u7269\u6d41\u8fd4\u56de\u4fe1\u606f: {}", (Object)responseXml);
            SFResponse response = new SFResponse();
            response = (SFResponse)XmlUtil.toObject((String)responseXml, SFResponse.class);
            if (response.getHead().equals("OK") && response.getResponseBody() != null && response.getResponseBody().getRouteResponse() != null) {
                List<SFRoute> list = response.getResponseBody().getRouteResponse().getRoute();
                Collections.sort(list, new Comparator<SFRoute>(){

                    @Override
                    public int compare(SFRoute o1, SFRoute o2) {
                        return o2.getAcceptTime().compareTo(o1.getAcceptTime());
                    }
                });
                return response;
            }
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u987a\u4e30\u5feb\u9012\u7269\u6d41\u5f02\u5e38 e={}", (Throwable)e);
        }
        return null;
    }
}

