package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * Created by feilong.gao on 2017/3/31.
 */
public class ElementPool  implements Comparable<ElementPool> {

    private List<RedElement> eles;

    private Integer minEleCount ;

    private Integer totalCount;

    private Integer maxPrice;

    private Integer minPrice;

    private Integer totalPrice;

    private Integer weight;

    public ElementPool(){};

    public ElementPool(ElementPool elementPool){
        this.minEleCount = elementPool.getMinEleCount();
        this.totalCount = elementPool.getTotalCount();
        this.maxPrice = elementPool.getMaxPrice();
        this.minPrice = elementPool.getMinPrice();
        this.totalPrice = elementPool.getTotalPrice();
        this.weight = elementPool.getWeight();
    };

    public List<RedElement> getEles() {
        return eles;
    }

    public void setEles(List<RedElement> eles) {
        Collections.sort(eles);
        this.eles =eles;
    }

    public Integer getMinEleCount() {
        return minEleCount;
    }

    public void setMinEleCount(Integer minEleCount) {
        this.minEleCount = minEleCount;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Integer maxPrice) {
        this.maxPrice = maxPrice;
    }

    public Integer getMinPrice() {
        return minPrice;
    }

    public void setMinPrice(Integer minPrice) {
        this.minPrice = minPrice;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getTotalPrice() {

        if(CollectionUtils.isNotEmpty(eles)){
            totalPrice = 0;
            for(RedElement redElement : eles){
                totalPrice += redElement.getValue() * redElement.getNum();
            }
        }
        return totalPrice;
    }

    public void setTotalPrice(Integer totalPrice) {
        this.totalPrice = totalPrice;
    }

    @Override
    public int compareTo(ElementPool o) {
        if(this.weight>o.weight){
            return 1;
        }else if(this.weight<o.weight){
            return -1;
        }
        return 0;
    }


    public ElementPool getRandomElements(){
        ElementPool elementPool = new ElementPool(this);
        List<RedElement> list = Lists.newArrayList();
        Map<Integer,Integer> map = new HashMap<>();
        do{
            map.clear();
            for(int i = 0; i<totalCount ; i++){
                int idx = new Random().nextInt(eles.size());

                if(null == map.get(idx)){
                    map.put(idx,1);
                }else{
                    map.put(idx,map.get(idx)+1);
                }
            }
        }while (map.size()<minEleCount);

        for(Map.Entry<Integer,Integer> entry :map.entrySet()){
            eles.get(entry.getKey());
            RedElement redElement = new RedElement(eles.get(entry.getKey()));
            redElement.setNum(entry.getValue());
            list.add(redElement);
        }
        elementPool.setEles(list);
        return elementPool;
    }
}
