package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopeRecordMapper;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeRecordDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeRecord;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeRecordExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeRecordService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2016/12/20.
 */
@Service
public class RedEnvelopeRecordServiceImpl implements RedEnvelopeRecordService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedEnvelopeRecordMapper mapper;
    @Autowired
    private RedisService redisService;
    private String RED_ENVELOPE_RECORDS_KEY = "RE_RECORDS_";

    @Override
    public RedEnvelopeRecordDTO saveRedEnveloperRecord(RedEnvelopeRecordDTO redEnvelopeRecordDTO) {
        RedEnvelopeRecordDTO result = null;
        if(redEnvelopeRecordDTO ==null){
            logger.warn("保存红包领取记录入参：为空");
        }else{
            logger.warn("保存红包领取记录入参：{}", JSON.toJSONString(redEnvelopeRecordDTO));
            RedEnvelopeRecord record = BeanUtil.buildFrom(redEnvelopeRecordDTO,RedEnvelopeRecord.class);
            record.setCreateTime(new Date());
            mapper.insert(record);
            result = BeanUtil.buildFrom(record,RedEnvelopeRecordDTO.class);
        }
        logger.info("保存红包领取记录返回：{}",JSON.toJSONString(result));
        return result;
    }


    @Override
    public List<RedEnvelopeRecordDTO> queryRecordByActivityId(String shareActivityId){
        logger.info("根据分享活动[{}]查询红包领取记录",shareActivityId);
        RedEnvelopeRecordExample example = new RedEnvelopeRecordExample();
        example.createCriteria().andShareActivityIdEqualTo(shareActivityId);
        List<RedEnvelopeRecord> list = mapper.selectByExample(example);
        List<RedEnvelopeRecordDTO> result  = BeanUtil.buildListFrom(list,RedEnvelopeRecordDTO.class);
        logger.info("分享活动[{}]红包领取记录：{}",shareActivityId,JSON.toJSONString(result));
        return result;
    }

    /**
     * 获取红包分享列表rediskey
     *
     * @param shareId
     * @return
     */
    private String getRedEnveloperRedisKey(String shareId) {
        return RED_ENVELOPE_RECORDS_KEY + shareId;
    }

}
