package com.thebeastshop.pegasus.component.redenvelope.service;

import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroup;

import java.util.List;

/**
 * 红包奖品组服务
 * Created by feilong.gao on 2017/2/13.
 */
public interface RedEnvelopePrizeGroupService {

    /**
     * 添加红包奖品组
     * @param prizeGroups
     * @return
     */
    Boolean addRedEnvelopePrizeGroup(List<RedEnvelopePrizeGroup> prizeGroups);

    /**
     * 更新库存
     * @param id
     * @return
     */
    Boolean updateStock(Long id);

    /**
     * 根据活动Id获取奖品集合
     * @param activityId
     * @return
     */
    List<RedEnvelopePrizeGroup> getPrizeGroupByActiveId(Long activityId);

}
